/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.mock.MockModule;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;

import java.util.List;


public class SpyProcessor extends AbstractMockProcessor {

  public static final String PROCESSOR_NAME = "spy";

  private transient Log logger = LogFactory.getLog(this.getClass());

  protected Object assertionsBeforeCall;
  protected Object assertionsAfterCall;

  public void initialise() throws InitialisationException {
    super.initialise();
    if (assertionsBeforeCall instanceof List) {
      for (Processor processor : ((List<Processor>) assertionsBeforeCall)) {
        if (processor instanceof Initialisable) {
          ((Initialisable) processor).initialise();
        }
      }
    }
    if (assertionsAfterCall instanceof List) {
      for (Processor processor : ((List<Processor>) assertionsAfterCall)) {
        if (processor instanceof Initialisable) {
          ((Initialisable) processor).initialise();
        }
      }
    }
  }


  /**
   * Sets assertionsBeforeCall
   *
   * @param value Value to set
   */
  public void setAssertionsBeforeCall(Object value) {
    this.assertionsBeforeCall = value;
  }


  /**
   * Sets assertionsAfterCall
   *
   * @param value Value to set
   */
  public void setAssertionsAfterCall(Object value) {
    this.assertionsAfterCall = value;
  }

  /**
   * Invokes the Processor.
   *
   * @param event MuleEvent to be processed
   * @param module the MockModule
   * @throws Exception
   */
  protected void doProcess(Event event, MockModule module) throws Exception {
    module.spy(
               processor,
               getEvaluatedAttributes(withAttributes, event),
               transformAssertions(assertionsBeforeCall, event),
               transformAssertions(assertionsAfterCall, event));
  }

  @Override
  protected String getProcessorName() {
    return PROCESSOR_NAME;
  }

}
