/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.tool;


import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.mock.behavior.DefaultBehaviorManager;
import org.mule.runtime.core.api.MuleContext;

import java.util.HashMap;
import java.util.Map;

/**
 * This is the general MUnit Tool
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public abstract class AbstractMockingTool {

  protected MuleContext muleContext;

  protected String processorName;
  protected String processorNamespace = "mule";
  protected Map<String, Object> processorAttributes = new HashMap<>();

  public AbstractMockingTool(MuleContext muleContext) {
    this.muleContext = muleContext;
  }

  protected void checkValidQuery() {
    if (processorName == null) {
      throw new IllegalArgumentException("You must provide at least the processor name");
    }
  }

  protected DefaultBehaviorManager getManager() {
    return (DefaultBehaviorManager) muleContext.getRegistry().lookupObject(BehaviorManager.ID);
  }

  protected String getFullName() {
    return processorNamespace + ":" + processorName;
  }

}
