/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.tool.spy;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;

/**
 * if you want to spy something this is the method that you need to implement
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public interface SpyProcess {

  /**
   * Executes code in the spying process
   *
   * @param event The {@link Event}
   * @throws MuleException In case of spy failure
   */
  void spy(Event event) throws MuleException;


}
