/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.tool.spy;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;

import java.util.List;

public class SpyProcessContainer implements Processor, SpyProcessorContainer {

  private final List<SpyProcess> spyProcesses;

  public SpyProcessContainer(List<SpyProcess> spyProcesses) {
    this.spyProcesses = spyProcesses;
  }

  @Override
  public Event process(Event event) throws MuleException {
    if (spyProcesses != null) {
      for (SpyProcess process : spyProcesses) {
        process.spy(event);
      }
    }
    return event;
  }

  @Override
  public Boolean containsProcessors() {
    if (null != spyProcesses && !spyProcesses.isEmpty()) {
      if (!spyProcesses.isEmpty()) {
        if (SpyProcessorContainer.class.isAssignableFrom(spyProcesses.get(0).getClass())) {
          return ((SpyProcessImpl) spyProcesses.get(0)).containsProcessors();
        } else {
          // If we can't cast we have to assume it has something
          return true;
        }
      }
    }
    return false;
  }

}
