/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.tool.spy;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;

import java.util.List;

/**
 * Simple implementation of SpyProcess, who knows to process each of the contained processors.
 */
public class SpyProcessImpl implements SpyProcess, SpyProcessorContainer {

  private List<Processor> processorsFrom;

  public SpyProcessImpl(List<Processor> processorsFrom) {
    this.processorsFrom = processorsFrom;
  }

  @Override
  public void spy(Event event) throws MuleException {
    for (Processor mp : processorsFrom) {
      mp.process(event);
    }
  }

  @Override
  public Boolean containsProcessors() {
    if (null != processorsFrom && !processorsFrom.isEmpty()) {
      return processorsFrom.get(0) != null;
    }
    return false;
  }
}

