/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.munit.common.event.DataTypeBuilder;
import org.mule.munit.common.event.MessageBuilderDecorator;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.TypedKeyValue;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;

public class InterceptingEventBuilder {
    public InterceptionEvent build(InterceptionEvent originalEvent, Optional<Event> mockedEvent) {
        if (!mockedEvent.isPresent()) {
            return originalEvent;
        }
        if (null != mockedEvent.get().getVariables()) {
            mockedEvent.get().getVariables().forEach(v -> originalEvent.addVariable(v.getKey(), (Object)v.getValue(), DataTypeBuilder.fromTypedKeyValue((TypedKeyValue)v).build()));
        }
        originalEvent.message(this.buildMessage(mockedEvent.get()));
        return originalEvent;
    }

    private Message buildMessage(Event mockedEvent) {
        MessageBuilderDecorator builder = new MessageBuilderDecorator();
        Payload mockedEventPayload = mockedEvent.getPayload();
        builder.withPayload(mockedEventPayload.getValue());
        if (mockedEventPayload.getMediaType() != null) {
            MediaType mediaType = MediaType.parse((String)mockedEventPayload.getMediaType());
            if (mockedEventPayload.getEncoding() != null) {
                mediaType = mediaType.withCharset(Charset.forName(mockedEventPayload.getEncoding()));
            }
            builder.withMediaType(mediaType);
        }
        if (null != mockedEvent.getInboundProperties()) {
            mockedEvent.getInboundProperties().forEach(p -> builder.withInboundProperty(p.getKey(), (Object)p.getValue(), p.getMediaType(), p.getEncoding()));
        }
        if (null != mockedEvent.getOutboundProperties()) {
            mockedEvent.getOutboundProperties().forEach(p -> builder.withOutboundProperty(p.getKey(), (Object)p.getValue(), p.getMediaType(), p.getEncoding()));
        }
        if (null != mockedEvent.getInboundAttachments()) {
            mockedEvent.getInboundAttachments().forEach(a -> builder.withInboundAttachment(a.getKey(), a.getDataHandler()));
        }
        if (null != mockedEvent.getOutboundAttachments()) {
            mockedEvent.getOutboundAttachments().forEach(a -> builder.withOutboundAttachment(a.getKey(), a.getDataHandler()));
        }
        return builder.build();
    }
}

