/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.processors;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.model.Attribute;
import org.mule.munit.common.util.MunitExpressionWrapper;
import org.mule.munit.mock.MockModule;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.NestedProcessor;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.chain.NestedProcessorChain;

public abstract class AbstractMockProcessor
extends AbstractAnnotatedObject
implements Initialisable,
Processor,
FlowConstructAware {
    protected Object moduleObject;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected MunitExpressionWrapper expressionWrapper;
    protected String processor;
    protected List<Attribute> withAttributes;

    public String getProcessor() {
        return this.processor;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public List<Attribute> getWithAttributes() {
        return this.withAttributes;
    }

    public void setWithAttributes(List<Attribute> withAttributes) {
        this.withAttributes = withAttributes;
    }

    public void initialise() throws InitialisationException {
        this.expressionWrapper = new MunitExpressionWrapper(this.muleContext.getExpressionManager());
        try {
            this.moduleObject = this.findOrCreate(MockModule.class, true);
        }
        catch (IllegalAccessException | InstantiationException | ConfigurationException e) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"Cannot find object"), (Initialisable)this);
        }
        catch (RegistrationException e) {
            throw new InitialisationException(CoreMessages.initialisationFailure((String)MockModule.class.getCanonicalName()), (Throwable)e, (Initialisable)this);
        }
    }

    protected final Object findOrCreate(Class<?> moduleClass, boolean shouldAutoCreate) throws IllegalAccessException, InstantiationException, ConfigurationException, RegistrationException {
        Object temporaryObject = this.moduleObject;
        if (temporaryObject == null && (temporaryObject = this.muleContext.getRegistry().lookupObject(moduleClass)) == null) {
            if (shouldAutoCreate) {
                temporaryObject = moduleClass.newInstance();
                this.muleContext.getRegistry().registerObject(moduleClass.getName(), temporaryObject);
            } else {
                throw new ConfigurationException(CoreMessages.createStaticMessage((String)"Cannot find object"));
            }
        }
        return temporaryObject;
    }

    protected MockModule getModule(Event event, String methodName) throws MessagingException {
        MockModule castedModuleObject;
        if (this.moduleObject instanceof String) {
            castedModuleObject = (MockModule)this.muleContext.getRegistry().lookupObject((String)this.moduleObject);
            if (castedModuleObject == null) {
                throw new MessagingException(CoreMessages.failedToCreate((String)methodName), event, (Throwable)new RuntimeException("Cannot find the configuration specified by the org.mule.munit.config-ref attribute."));
            }
        } else {
            castedModuleObject = (MockModule)this.moduleObject;
        }
        return castedModuleObject;
    }

    public Event process(Event event) throws MuleException {
        MockModule module = this.getModule(event, this.getProcessorName());
        try {
            this.doProcess(event, module);
            return event;
        }
        catch (AssertionError error) {
            AssertionError exception = new AssertionError((Object)this.getMessage(error));
            throw exception;
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke((String)this.getProcessorName()), event, (Throwable)e);
        }
    }

    protected abstract void doProcess(Event var1, MockModule var2) throws Exception;

    protected abstract String getProcessorName();

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setModuleObject(Object moduleObject) {
        this.moduleObject = moduleObject;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    private String getMessage(AssertionError error) {
        String message = ((Throwable)((Object)error)).getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return this.getProcessorName();
        }
        return message;
    }

    protected List<Attribute> getEvaluatedAttributes(Object attributes, Event event) {
        ArrayList<Attribute> evaluatedAttributes = new ArrayList<Attribute>();
        if (attributes != null) {
            for (Attribute attribute : (List)attributes) {
                if (this.isInvalidExpression(attribute.getAttributeName())) {
                    throw new MunitError("mock:with-attributes parsing fail. The name " + attribute.getAttributeName() + "is an invalid expression.");
                }
                if (this.isInvalidExpression(attribute.getWhereValue())) {
                    throw new MunitError("mock:with-attributes parsing fail. The whereValue " + attribute.getWhereValue() + "is an invalid expression.");
                }
                evaluatedAttributes.add(attribute.getEvaluatedAttribute(event, this.expressionWrapper));
            }
        }
        return evaluatedAttributes;
    }

    protected boolean isInvalidExpression(Object expression) {
        return this.expressionWrapper.isExpression(expression) && !this.expressionWrapper.isExpressionValid(expression);
    }

    protected List<NestedProcessor> transformAssertions(Object assertions, Event event) {
        ArrayList<NestedProcessor> transformedAssertions = new ArrayList<NestedProcessor>();
        if (assertions != null) {
            for (Processor processor : (List)assertions) {
                transformedAssertions.add((NestedProcessor)new NestedProcessorChain(event, processor));
            }
        }
        return transformedAssertions;
    }
}

