/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.NullObject;
import org.mule.munit.mock.behavior.MockBehavior;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;

public class MockingValidator {
    public static final List<String> NON_MOCKABLE_CORE_PROCESSORS = Arrays.asList("logger", "ee:transform");
    private transient Log logger = LogFactory.getLog(this.getClass());
    private ComponentLocation location;

    public MockingValidator(ComponentLocation location) {
        Preconditions.checkNotNull((Object)location, (Object)"The location must not be null.");
        this.location = location;
    }

    public Boolean allowMocking() {
        TypedComponentIdentifier.ComponentType type = this.location.getComponentIdentifier().getType();
        if (type.equals((Object)TypedComponentIdentifier.ComponentType.FLOW) || type.equals((Object)TypedComponentIdentifier.ComponentType.SOURCE) || type.equals((Object)TypedComponentIdentifier.ComponentType.SCOPE) || type.equals((Object)TypedComponentIdentifier.ComponentType.ROUTER) || type.equals((Object)TypedComponentIdentifier.ComponentType.INTERCEPTING) || type.equals((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER) || type.equals((Object)TypedComponentIdentifier.ComponentType.ON_ERROR) || type.equals((Object)TypedComponentIdentifier.ComponentType.UNKNOWN)) {
            return false;
        }
        if (type.equals((Object)TypedComponentIdentifier.ComponentType.PROCESSOR) && NON_MOCKABLE_CORE_PROCESSORS.contains(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return false;
        }
        return true;
    }

    public Boolean isBehaviorValid(MockBehavior behavior) {
        if (!this.allowMocking().booleanValue()) {
            this.logger.error((Object)(this.getBaseErrorMessage() + " This component does not allow mocking"));
            return false;
        }
        TypedComponentIdentifier.ComponentType type = this.location.getComponentIdentifier().getType();
        switch (type) {
            case OPERATION: {
                return this.isBehaviorValidForOperation(behavior);
            }
            case PROCESSOR: {
                return this.isBehaviorValidForProcessor(behavior);
            }
        }
        return true;
    }

    private boolean isBehaviorValidForOperation(MockBehavior behavior) {
        if (!behavior.getEvent().isPresent()) {
            return true;
        }
        String baseErrorMessage = this.getBaseErrorMessage() + " This component does not allow definition of";
        Event event = behavior.getEvent().get();
        if (!this.isBehaviorValidForCommonNotAllowedElements(behavior, baseErrorMessage).booleanValue()) {
            return false;
        }
        if (event.getVariables() != null) {
            this.logger.error((Object)(baseErrorMessage + " variables."));
            return false;
        }
        return true;
    }

    private boolean isBehaviorValidForProcessor(MockBehavior behavior) {
        if (!behavior.getEvent().isPresent()) {
            return true;
        }
        String baseErrorMessage = this.getBaseErrorMessage() + " This component does not allow definition of";
        if ("set-payload".equals(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return this.isBehaviorValidForSetPayload(behavior, baseErrorMessage);
        }
        if ("set-variable".equals(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return this.isBehaviorValidForSetVariable(behavior, baseErrorMessage);
        }
        return true;
    }

    private boolean isBehaviorValidForSetPayload(MockBehavior behavior, String baseErrorMessage) {
        Event event = behavior.getEvent().get();
        if (!this.isBehaviorValidForCommonNotAllowedElements(behavior, baseErrorMessage).booleanValue()) {
            return false;
        }
        if (event.getAttributes() != null && !(event.getAttributes().getValue() instanceof NullObject)) {
            this.logger.error((Object)(baseErrorMessage + " attributes."));
            return false;
        }
        if (event.getVariables() != null) {
            this.logger.error((Object)(baseErrorMessage + " variables."));
            return false;
        }
        return true;
    }

    private boolean isBehaviorValidForSetVariable(MockBehavior behavior, String baseErrorMessage) {
        Event event = behavior.getEvent().get();
        if (!this.isBehaviorValidForCommonNotAllowedElements(behavior, baseErrorMessage).booleanValue()) {
            return false;
        }
        if (event.getAttributes() != null && !(event.getAttributes().getValue() instanceof NullObject)) {
            this.logger.error((Object)(baseErrorMessage + " attributes."));
            return false;
        }
        if (event.getPayload() != null && !(event.getPayload().getValue() instanceof NullObject)) {
            this.logger.error((Object)(baseErrorMessage + " payload."));
            return false;
        }
        return true;
    }

    private Boolean isBehaviorValidForCommonNotAllowedElements(MockBehavior behavior, String baseErrorMessage) {
        Event event = behavior.getEvent().get();
        if (event.getSessionProperties() != null) {
            this.logger.error((Object)(baseErrorMessage + " session properties."));
            return false;
        }
        if (event.getOutboundProperties() != null) {
            this.logger.error((Object)(baseErrorMessage + " outbound properties."));
            return false;
        }
        if (event.getInboundProperties() != null) {
            this.logger.error((Object)(baseErrorMessage + " inbound properties."));
            return false;
        }
        if (event.getInboundAttachments() != null) {
            this.logger.error((Object)(baseErrorMessage + " inbound attachments."));
            return false;
        }
        if (event.getOutboundAttachments() != null) {
            this.logger.error((Object)(baseErrorMessage + " outbound attachments."));
            return false;
        }
        return true;
    }

    public String getBaseErrorMessage() {
        String identifier = this.location.getComponentIdentifier().getIdentifier().toString();
        String baseErrorMessage = "You have defined a behavior for " + identifier + " in " + this.location.getFileName().orElse(" ? ") + "[line: " + this.location.getLineInFile().orElse(-1) + "].";
        return baseErrorMessage;
    }
}

