/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.NullObject;
import org.mule.munit.mock.behavior.MockBehavior;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockingValidator {
    public static final List<String> NON_MOCKABLE_CORE_OPERATIONS = Arrays.asList("logger", "ee:transform");
    public static final List<String> SPECIAL_CORE_OPERATIONS = Arrays.asList("set-payload", "set-variable");
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ComponentLocation location;

    public MockingValidator(ComponentLocation location) {
        Preconditions.checkNotNull((Object)location, (Object)"The location must not be null.");
        this.location = location;
    }

    public Boolean allowMocking() {
        TypedComponentIdentifier.ComponentType type = this.location.getComponentIdentifier().getType();
        if (type.equals((Object)TypedComponentIdentifier.ComponentType.FLOW) || type.equals((Object)TypedComponentIdentifier.ComponentType.SOURCE) || type.equals((Object)TypedComponentIdentifier.ComponentType.SCOPE) || type.equals((Object)TypedComponentIdentifier.ComponentType.ROUTER) || type.equals((Object)TypedComponentIdentifier.ComponentType.INTERCEPTING) || type.equals((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER) || type.equals((Object)TypedComponentIdentifier.ComponentType.ON_ERROR) || type.equals((Object)TypedComponentIdentifier.ComponentType.UNKNOWN)) {
            return false;
        }
        if (type.equals((Object)TypedComponentIdentifier.ComponentType.OPERATION) && NON_MOCKABLE_CORE_OPERATIONS.contains(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return false;
        }
        return true;
    }

    public Boolean isBehaviorValid(MockBehavior behavior) {
        if (!this.allowMocking().booleanValue()) {
            this.logger.error(this.getBaseErrorMessage() + " This component does not allow mocking");
            return false;
        }
        TypedComponentIdentifier.ComponentType type = this.location.getComponentIdentifier().getType();
        switch (type) {
            case OPERATION: {
                return this.isBehaviorValidForOperation(behavior);
            }
        }
        return true;
    }

    private boolean isBehaviorValidForOperation(MockBehavior behavior) {
        if (!behavior.getEvent().isPresent()) {
            return true;
        }
        if ("flow-ref".equals(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return true;
        }
        String baseErrorMessage = this.getBaseErrorMessage() + " This component does not allow definition of";
        if (SPECIAL_CORE_OPERATIONS.contains(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return this.isBehaviorValidForCoreOperations(behavior, baseErrorMessage);
        }
        Event event = behavior.getEvent().get();
        if (!this.isBehaviorValidForCommonNotAllowedElements(behavior, baseErrorMessage).booleanValue()) {
            return false;
        }
        if (event.getVariables() != null) {
            this.logger.error(baseErrorMessage + " variables.");
            return false;
        }
        return true;
    }

    private boolean isBehaviorValidForCoreOperations(MockBehavior behavior, String baseErrorMessage) {
        if ("set-payload".equals(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return this.isBehaviorValidForSetPayload(behavior, baseErrorMessage);
        }
        if ("set-variable".equals(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return this.isBehaviorValidForSetVariable(behavior, baseErrorMessage);
        }
        return true;
    }

    private boolean isBehaviorValidForSetPayload(MockBehavior behavior, String baseErrorMessage) {
        Event event = behavior.getEvent().get();
        if (!this.isBehaviorValidForCommonNotAllowedElements(behavior, baseErrorMessage).booleanValue()) {
            return false;
        }
        if (event.getAttributes() != null && !(event.getAttributes().getValue() instanceof NullObject)) {
            this.logger.error(baseErrorMessage + " attributes.");
            return false;
        }
        if (event.getVariables() != null) {
            this.logger.error(baseErrorMessage + " variables.");
            return false;
        }
        return true;
    }

    private boolean isBehaviorValidForSetVariable(MockBehavior behavior, String baseErrorMessage) {
        Event event = behavior.getEvent().get();
        if (!this.isBehaviorValidForCommonNotAllowedElements(behavior, baseErrorMessage).booleanValue()) {
            return false;
        }
        if (event.getAttributes() != null && !(event.getAttributes().getValue() instanceof NullObject)) {
            this.logger.error(baseErrorMessage + " attributes.");
            return false;
        }
        if (event.getPayload() != null && !(event.getPayload().getValue() instanceof NullObject)) {
            this.logger.error(baseErrorMessage + " payload.");
            return false;
        }
        return true;
    }

    private Boolean isBehaviorValidForCommonNotAllowedElements(MockBehavior behavior, String baseErrorMessage) {
        Event event = behavior.getEvent().get();
        if (event.getSessionProperties() != null) {
            this.logger.error(baseErrorMessage + " session properties.");
            return false;
        }
        if (event.getOutboundProperties() != null) {
            this.logger.error(baseErrorMessage + " outbound properties.");
            return false;
        }
        if (event.getInboundProperties() != null) {
            this.logger.error(baseErrorMessage + " inbound properties.");
            return false;
        }
        if (event.getInboundAttachments() != null) {
            this.logger.error(baseErrorMessage + " inbound attachments.");
            return false;
        }
        if (event.getOutboundAttachments() != null) {
            this.logger.error(baseErrorMessage + " outbound attachments.");
            return false;
        }
        return true;
    }

    public String getBaseErrorMessage() {
        String identifier = this.location.getComponentIdentifier().getIdentifier().toString();
        String baseErrorMessage = "You have defined a behavior for " + identifier + " in " + this.location.getFileName().orElse(" ? ") + "[line: " + this.location.getLineInFile().orElse(-1) + "].";
        return baseErrorMessage;
    }
}

