/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.behavior;


import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.model.Event;

import java.util.Optional;

/**
 * The representation of a processor mocked behavior.
 *
 * It is used as a replacement of the real processor. We use this in order to know that the processor must return.
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MockBehavior extends Behavior {

  /**
   * The {@link Event} that will change the {@link Event} of the processor. Is null if the event should remain the same
   */
  private Event event;

  public MockBehavior(ProcessorCall processorCall, Event event) {
    super(processorCall);
    this.event = event;
  }

  public MockBehavior(ProcessorCall processorCall) {
    super(processorCall);
  }

  public Optional<Event> getEvent() {
    return Optional.ofNullable(event);
  }

}
