/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.mock.interception.MunitProcessorInterceptor;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;

public class MunitProcessorInterceptorFactory
implements ProcessorInterceptorFactory {
    private static final List<String> NON_INTERCEPTABLE_NAMESPACES = Arrays.asList("munit", "munit-tools");
    private BehaviorManager behaviorManager;
    private ErrorTypeRepository errorTypeRepository;

    @Inject
    public void setBehaviorManager(BehaviorManager behaviorManager) {
        this.behaviorManager = behaviorManager;
    }

    @Inject
    public void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    public ProcessorInterceptor get() {
        return this.createInterceptor(this.behaviorManager, this.errorTypeRepository);
    }

    public boolean intercept(ComponentLocation location) {
        TypedComponentIdentifier identifier = location.getComponentIdentifier();
        if (NON_INTERCEPTABLE_NAMESPACES.contains(identifier.getIdentifier().getNamespace())) {
            return false;
        }
        return TypedComponentIdentifier.ComponentType.OPERATION.equals((Object)identifier.getType());
    }

    protected MunitProcessorInterceptor createInterceptor(BehaviorManager behaviorManager, ErrorTypeRepository errorTypeRepository) {
        MunitProcessorInterceptor interceptor = new MunitProcessorInterceptor();
        interceptor.setManager(behaviorManager);
        interceptor.setErrorTypeRepository(errorTypeRepository);
        return interceptor;
    }
}

