/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.EventError;
import org.mule.munit.mock.behavior.DefaultBehaviorManager;
import org.mule.munit.mock.behavior.MockBehavior;
import org.mule.munit.mock.behavior.SpyBehavior;
import org.mule.munit.mock.interception.InterceptingEventBuilder;
import org.mule.munit.mock.interception.MockingValidator;
import org.mule.munit.mock.tool.spy.SpyExecutionException;
import org.mule.munit.mock.tool.spy.SpyProcess;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.interception.InternalInterceptionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MunitProcessorInterceptor
implements ProcessorInterceptor {
    private static final String ENABLE_INCONSISTENT_MOCKING_PROPERTY = "enable-inconsistent-mocking";
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private DefaultBehaviorManager manager;
    private ErrorTypeRepository errorTypeRepository;
    private Map<String, ProcessorCall> processorCalls = new ConcurrentHashMap<String, ProcessorCall>();

    public void setManager(BehaviorManager manager) {
        this.manager = (DefaultBehaviorManager)manager;
    }

    protected DefaultBehaviorManager getManager() {
        if (this.manager == null) {
            throw new IllegalStateException("There is no manager defined");
        }
        return this.manager;
    }

    public void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        this.logger.debug("Retrieving Spy Before behavior for processor: " + this.locationToStringLog(location));
        Map<String, Object> resolvedParameters = this.resolveParameters(parameters);
        ProcessorCall processorCall = this.buildCall(this.getIdentifier(location), resolvedParameters);
        this.processorCalls.put(event.getContext().getId(), processorCall);
        this.getManager().addCall(processorCall);
        Optional<SpyBehavior> betterMatchingBehavior = this.getManager().getBetterMatchingBeforeSpyBehavior(processorCall);
        betterMatchingBehavior.ifPresent(spyBehavior -> this.runSpy((SpyBehavior)spyBehavior, event));
    }

    public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
        this.logger.debug("Retrieving mocked behavior for processor: " + this.locationToStringLog(location));
        Map<String, Object> resolvedParameters = this.resolveParameters(parameters);
        ProcessorCall processorCall = this.buildCall(this.getIdentifier(location), resolvedParameters);
        Optional<MockBehavior> betterMatchingBehavior = this.getManager().getBetterMatchingBehavior(processorCall);
        if (betterMatchingBehavior.isPresent()) {
            MockBehavior behavior = betterMatchingBehavior.get();
            MockingValidator mockingValidator = new MockingValidator(location);
            this.haltIfMockingNotAllowed(mockingValidator);
            this.haltIfInvalidBehavior(mockingValidator, behavior);
            if (this.shouldFailProcessor(behavior)) {
                this.logger.debug("Mock behavior found. Throwing exception instead of " + this.locationToStringLog(location));
                return this.failProcessor(event, action, behavior);
            }
            this.logger.debug("Mock behavior found. Executing that instead of " + this.locationToStringLog(location));
            return this.returnBehavior(event, action, behavior);
        }
        return action.proceed();
    }

    public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        this.logger.debug("Retrieving Spy After behavior for processor: " + this.locationToStringLog(location));
        String eventContextId = event.getContext().getId();
        if (thrown.isPresent()) {
            this.logger.debug("Spy after won't run. The processor " + this.locationToStringLog(location) + " failed: " + thrown.get().getMessage());
        } else {
            if (!this.processorCalls.containsKey(eventContextId)) {
                throw new MunitError("Spy after won't run. The processor " + this.locationToStringLog(location) + " was not executed before");
            }
            Optional<SpyBehavior> betterMatchingBehavior = this.getManager().getBetterMatchingAfterSpyBehavior(this.processorCalls.get(eventContextId));
            betterMatchingBehavior.ifPresent(spyBehavior -> this.runSpy((SpyBehavior)spyBehavior, event));
        }
    }

    private ProcessorCall buildCall(ComponentIdentifier componentIdentifier, Map<String, Object> parameters) {
        ProcessorId id = new ProcessorId(componentIdentifier.getName(), componentIdentifier.getNamespace());
        ProcessorCall call = new ProcessorCall(id);
        call.setAttributes(parameters);
        return call;
    }

    private boolean shouldFailProcessor(MockBehavior behavior) {
        Optional<Event> behaviorEvent = behavior.getEvent();
        EventError behaviorError = behaviorEvent.isPresent() ? behaviorEvent.get().getError() : null;
        boolean isThereAnEvent = behaviorEvent.isPresent();
        boolean isThereAnErrorCause = behaviorError != null ? behaviorError.getCause() != null : false;
        boolean isThereAnErrorTypeId = behaviorError != null ? StringUtils.isNotBlank((CharSequence)behaviorError.getTypeId()) : false;
        return isThereAnEvent && (isThereAnErrorCause || isThereAnErrorTypeId);
    }

    private CompletableFuture<InterceptionEvent> returnBehavior(InterceptionEvent event, InterceptionAction action, MockBehavior behavior) {
        action.skip();
        Optional<Event> mockedEvent = behavior.getEvent();
        return CompletableFuture.supplyAsync(() -> this.buildInterceptingEvent(event, mockedEvent));
    }

    private CompletableFuture<InterceptionEvent> failProcessor(InterceptionEvent event, InterceptionAction action, MockBehavior behavior) {
        this.buildInterceptingEvent(event, behavior.getEvent());
        Event behaviorEvent = behavior.getEvent().get();
        if (behaviorEvent.getError().getCause() != null) {
            return action.fail((Throwable)behaviorEvent.getError().getCause());
        }
        ComponentIdentifier componentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)behaviorEvent.getError().getTypeId());
        Optional errorType = this.errorTypeRepository.getErrorType(componentIdentifier);
        return action.fail((ErrorType)errorType.get());
    }

    private InterceptionEvent buildInterceptingEvent(InterceptionEvent originalEvent, Optional<Event> mockedEvent) {
        return mockedEvent.map(event -> new InterceptingEventBuilder().build(originalEvent, (Event)event)).orElse(originalEvent);
    }

    private String locationToStringLog(ComponentLocation location) {
        return this.getIdentifier(location) + " in " + location.getFileName().orElse(" ? ") + "[line: " + location.getLineInFile().orElse(-1) + "].";
    }

    private ComponentIdentifier getIdentifier(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier();
    }

    private void haltIfMockingNotAllowed(MockingValidator mockingValidator) {
        if (this.enableInconsistentMocking().booleanValue()) {
            return;
        }
        if (!mockingValidator.allowMocking().booleanValue()) {
            String errorMessage = mockingValidator.getBaseErrorMessage() + ". Mocking of such elements is not allowed.";
            this.logger.error(errorMessage);
            throw new MunitError(errorMessage);
        }
    }

    private void haltIfInvalidBehavior(MockingValidator mockingValidator, MockBehavior behavior) {
        if (this.enableInconsistentMocking().booleanValue()) {
            return;
        }
        if (!mockingValidator.isBehaviorValid(behavior).booleanValue()) {
            String errorMessage = mockingValidator.getBaseErrorMessage() + ". The behavior contains invalid elements for the component.";
            this.logger.error(errorMessage);
            throw new MunitError(errorMessage);
        }
    }

    private void runSpy(SpyBehavior spyBehavior, InterceptionEvent event) {
        this.logger.debug("Spy behavior found. Running spy");
        PrivilegedEvent coreEvent = ((InternalInterceptionEvent)event).resolve();
        for (SpyProcess spyProcess : spyBehavior.getSpyProcesses()) {
            spyProcess.spy((CoreEvent)coreEvent).getThrowable().ifPresent(error -> {
                throw new SpyExecutionException("An error occurred during the execution of the spy", (Throwable)error);
            });
        }
    }

    private Map<String, Object> resolveParameters(Map<String, ProcessorParameterValue> parameters) {
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>();
        parameters.keySet().forEach(key -> resolvedParameters.put((String)key, new LazyValue(() -> ((ProcessorParameterValue)parameters.get(key)).resolveValue())));
        return resolvedParameters;
    }

    private Boolean enableInconsistentMocking() {
        return Boolean.valueOf(System.getProperty(ENABLE_INCONSISTENT_MOCKING_PROPERTY));
    }
}

