/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.NullObject;
import org.mule.munit.mock.behavior.Behavior;
import org.mule.munit.mock.behavior.CallBehaviour;
import org.mule.munit.mock.behavior.MockBehavior;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BehaviourValidator {
    private static final String LOGGER = "logger";
    private static final String TRANSFORM = "ee:transform";
    private static final String FLOW_REF = "flow-ref";
    private static final String SET_PAYLOAD = "set-payload";
    private static final String SET_VARIABLE = "set-variable";
    private static final List<TypedComponentIdentifier.ComponentType> NON_MOCKABLE_TYPES = Arrays.asList(TypedComponentIdentifier.ComponentType.FLOW, TypedComponentIdentifier.ComponentType.SOURCE, TypedComponentIdentifier.ComponentType.SCOPE, TypedComponentIdentifier.ComponentType.ROUTER, TypedComponentIdentifier.ComponentType.INTERCEPTING, TypedComponentIdentifier.ComponentType.ERROR_HANDLER, TypedComponentIdentifier.ComponentType.ON_ERROR, TypedComponentIdentifier.ComponentType.UNKNOWN);
    private static final List<String> NON_MOCKABLE_CORE_OPERATIONS = Arrays.asList("logger", "ee:transform");
    private static final List<String> SPECIAL_CORE_OPERATIONS = Arrays.asList("set-payload", "set-variable");
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ComponentLocation location;

    BehaviourValidator(ComponentLocation location) {
        Preconditions.checkNotNull((Object)location, (Object)"The location must not be null.");
        this.location = location;
    }

    Boolean allowMocking() {
        TypedComponentIdentifier.ComponentType type = this.location.getComponentIdentifier().getType();
        if (NON_MOCKABLE_TYPES.contains(type)) {
            return false;
        }
        return !NON_MOCKABLE_CORE_OPERATIONS.contains(this.location.getComponentIdentifier().getIdentifier().toString());
    }

    Boolean isBehaviorValid(Behavior behaviour) {
        if (!this.allowMocking().booleanValue()) {
            this.logger.error(this.getBaseErrorMessage() + " This component does not allow mocking");
            return false;
        }
        if (behaviour instanceof CallBehaviour && !behaviour.getEvent().isPresent()) {
            this.logger.error(this.getBaseErrorMessage() + " CallBehaviour returned no event");
            return false;
        }
        return !this.location.getComponentIdentifier().getType().equals((Object)TypedComponentIdentifier.ComponentType.OPERATION) || this.isBehaviorValidForOperation(behaviour);
    }

    String getBaseErrorMessage() {
        String identifier = this.location.getComponentIdentifier().getIdentifier().toString();
        return String.format("You have defined a behaviour for %s in %s [line: %s].", identifier, this.location.getFileName().orElse("?"), this.location.getLineInFile().orElse(-1));
    }

    private boolean isBehaviorValidForOperation(Behavior behaviour) {
        if (!behaviour.getEvent().isPresent()) {
            if (behaviour instanceof MockBehavior) {
                return true;
            }
            if (behaviour instanceof CallBehaviour) {
                return false;
            }
        }
        if (FLOW_REF.equals(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return true;
        }
        String baseErrorMessage = this.getBaseErrorMessage() + " This component does not allow definition of";
        if (SPECIAL_CORE_OPERATIONS.contains(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return this.isBehaviorValidForCoreOperations(behaviour, baseErrorMessage);
        }
        return this.isBehaviorValidForCommonNotAllowedElements(behaviour, baseErrorMessage);
    }

    private boolean isBehaviorValidForCoreOperations(Behavior behaviour, String baseErrorMessage) {
        String identifier = this.location.getComponentIdentifier().getIdentifier().toString();
        if (SET_PAYLOAD.equals(identifier)) {
            return this.isBehaviorValidForSetPayload(behaviour, baseErrorMessage);
        }
        return this.isBehaviorValidForSetVariable(behaviour, baseErrorMessage);
    }

    private boolean isBehaviorValidForSetPayload(Behavior behaviour, String baseErrorMessage) {
        if (!this.isBehaviorValidForCommonNotAllowedElements(behaviour, baseErrorMessage).booleanValue()) {
            return false;
        }
        Event event = behaviour.getEvent().get();
        if (event.getAttributes() != null && !(event.getAttributes().getValue() instanceof NullObject)) {
            this.logger.error(baseErrorMessage + " attributes.");
            return false;
        }
        if (event.getVariables() != null) {
            this.logger.error(baseErrorMessage + " variables.");
            return false;
        }
        return true;
    }

    private boolean isBehaviorValidForSetVariable(Behavior behaviour, String baseErrorMessage) {
        if (!this.isBehaviorValidForCommonNotAllowedElements(behaviour, baseErrorMessage).booleanValue()) {
            return false;
        }
        Event event = behaviour.getEvent().get();
        if (event.getAttributes() != null && !(event.getAttributes().getValue() instanceof NullObject)) {
            this.logger.error(baseErrorMessage + " attributes.");
            return false;
        }
        if (event.getPayload() != null && !(event.getPayload().getValue() instanceof NullObject)) {
            this.logger.error(baseErrorMessage + " payload.");
            return false;
        }
        return true;
    }

    private Boolean isBehaviorValidForCommonNotAllowedElements(Behavior behaviour, String baseErrorMessage) {
        Event event = behaviour.getEvent().get();
        if (event.getSessionProperties() != null) {
            this.logger.error(baseErrorMessage + " session properties.");
            return false;
        }
        if (event.getOutboundProperties() != null) {
            this.logger.error(baseErrorMessage + " outbound properties.");
            return false;
        }
        if (event.getInboundProperties() != null) {
            this.logger.error(baseErrorMessage + " inbound properties.");
            return false;
        }
        if (event.getInboundAttachments() != null) {
            this.logger.error(baseErrorMessage + " inbound attachments.");
            return false;
        }
        if (event.getOutboundAttachments() != null) {
            this.logger.error(baseErrorMessage + " outbound attachments.");
            return false;
        }
        return true;
    }
}

