/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.behavior;


import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.model.Event;

import java.util.Optional;

/**
 * Represents an behavior that has to be executed based on a {@link ProcessorCall}.
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public abstract class Behavior {

  private ProcessorCall processorCall;
  private Event event = null;

  protected Behavior(ProcessorCall processorCall) {
    this.processorCall = processorCall;
  }

  public ProcessorCall getProcessorCall() {
    return processorCall;
  }

  protected void setEvent(Event event) {
    this.event = event;
  }

  public Optional<Event> getEvent() {
    return Optional.ofNullable(event);
  }
}
