/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.tool.spy;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.mock.behavior.SpyBehavior;
import org.mule.munit.mock.tool.AbstractMockingTool;
import org.mule.munit.mock.tool.spy.SpyProcess;
import org.mule.runtime.api.artifact.Registry;

public class Spy
extends AbstractMockingTool {
    public Spy(Registry registry) {
        super(registry);
    }

    public Spy spyProcessor(String name) {
        this.processorName = name;
        return this;
    }

    public Spy ofNamespace(String namespace) {
        this.processorNamespace = namespace;
        return this;
    }

    public Spy withAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            this.processorAttributes = attributes;
        }
        return this;
    }

    public Spy before(List<SpyProcess> withSpies) {
        if (withSpies != null && !withSpies.isEmpty()) {
            ProcessorCall processorCall = this.createProcessorCall();
            this.getManager().addBeforeCallSpyBehavior(this.createSpyBehavior(processorCall, withSpies));
        }
        return this;
    }

    private ProcessorCall createProcessorCall() {
        ProcessorCall processorCall = new ProcessorCall(new ProcessorId(this.processorName, this.processorNamespace));
        processorCall.setAttributes(this.processorAttributes);
        return processorCall;
    }

    public Spy before(SpyProcess ... withSpy) {
        return this.before(Arrays.asList(withSpy));
    }

    public Spy after(List<SpyProcess> withSpies) {
        if (withSpies != null && !withSpies.isEmpty()) {
            ProcessorCall processorCall = this.createProcessorCall();
            this.getManager().addAfterCallSpyBehavior(this.createSpyBehavior(processorCall, withSpies));
        }
        return this;
    }

    public Spy after(SpyProcess ... withSpy) {
        return this.after(Arrays.asList(withSpy));
    }

    protected SpyBehavior createSpyBehavior(ProcessorCall call, List<SpyProcess> spyProcesses) {
        return new SpyBehavior(call, spyProcesses);
    }
}

