/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.mock.interception.MunitProcessorInterceptor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MunitProcessorInterceptorFactory
implements ProcessorInterceptorFactory {
    private static final String MUNIT_NAMESPACE = "munit";
    private static final String MUNIT_TOOLS_NAMESPACE = "munit-tools";
    private static final List<String> NON_INTERCEPTABLE_NAMESPACES = Arrays.asList("munit", "munit-tools");
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private BehaviorManager behaviorManager;
    private ErrorTypeRepository errorTypeRepository;

    @Inject
    public void setBehaviorManager(BehaviorManager behaviorManager) {
        this.behaviorManager = behaviorManager;
    }

    @Inject
    public void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    public ProcessorInterceptor get() {
        return this.createInterceptor(this.behaviorManager, this.errorTypeRepository);
    }

    public boolean intercept(ComponentLocation location) {
        TypedComponentIdentifier identifier = location.getComponentIdentifier();
        String name = identifier.getIdentifier().getName();
        if (NON_INTERCEPTABLE_NAMESPACES.contains(identifier.getIdentifier().getNamespace())) {
            this.logger.debug("Processor {} not intercepted. Non interceptable namespace.", (Object)name);
            return false;
        }
        if (!TypedComponentIdentifier.ComponentType.OPERATION.equals((Object)identifier.getType())) {
            this.logger.debug("Processor {} not intercepted. Component is not an operation.", (Object)name);
            return false;
        }
        if (this.isInsideMunitToolsSpy(location)) {
            this.logger.debug("Processor {} not intercepted. Component is located inside an MUnit Spy processor.", (Object)name);
            return false;
        }
        this.logger.debug("Processor {} successfully intercepted.", (Object)name);
        return true;
    }

    protected MunitProcessorInterceptor createInterceptor(BehaviorManager behaviorManager, ErrorTypeRepository errorTypeRepository) {
        MunitProcessorInterceptor interceptor = new MunitProcessorInterceptor();
        interceptor.setManager(behaviorManager);
        interceptor.setErrorTypeRepository(errorTypeRepository);
        return interceptor;
    }

    private boolean isInsideMunitToolsSpy(ComponentLocation location) {
        return location.getParts().stream().anyMatch(locationPart -> locationPart.getPartIdentifier().map(this::isMunitToolsSpy).orElse(false));
    }

    private boolean isMunitToolsSpy(TypedComponentIdentifier identifier) {
        ComponentIdentifier componentIdentifier = identifier.getIdentifier();
        return MUNIT_TOOLS_NAMESPACE.equals(componentIdentifier.getNamespace()) && "spy".equals(componentIdentifier.getName());
    }
}

