/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.mule.munit.common.api.model.Event;
import org.mule.munit.common.api.model.EventAttributes;
import org.mule.munit.common.api.model.NullObject;
import org.mule.munit.common.api.model.Payload;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.mock.behavior.Behavior;
import org.mule.munit.mock.behavior.CallBehaviour;
import org.mule.munit.mock.behavior.MockBehavior;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BehaviourValidator {
    private static final String LOGGER = "logger";
    private static final String TRANSFORM = "ee:transform";
    private static final String FLOW_REF = "flow-ref";
    private static final String SET_PAYLOAD = "set-payload";
    private static final String SET_VARIABLE = "set-variable";
    private static final Collection<String> NON_MOCKABLE_CORE_OPERATIONS = Arrays.asList("logger", "ee:transform");
    private static final Collection<String> SPECIAL_CORE_OPERATIONS = Arrays.asList("set-payload", "set-variable");
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ComponentLocation location;

    BehaviourValidator(ComponentLocation location) {
        this.location = (ComponentLocation)Preconditions.checkNotNull((Object)location, (String)"The location must not be null.");
    }

    boolean allowMocking() {
        return TypedComponentIdentifier.ComponentType.OPERATION.equals((Object)this.location.getComponentIdentifier().getType()) && !NON_MOCKABLE_CORE_OPERATIONS.contains(this.location.getComponentIdentifier().getIdentifier().toString());
    }

    boolean isBehaviorValid(Behavior behaviour) {
        if (!this.allowMocking()) {
            this.logger.error(this.getBaseErrorMessage() + " This component does not allow mocking");
            return false;
        }
        if (behaviour instanceof CallBehaviour && !behaviour.getEvent().isPresent()) {
            this.logger.error(this.getBaseErrorMessage() + " CallBehaviour returned no event");
            return false;
        }
        return this.isBehaviorValidForOperation(behaviour);
    }

    String getBaseErrorMessage() {
        String identifier = this.location.getComponentIdentifier().getIdentifier().toString();
        return String.format("You have defined a behavior for %s in %s [line: %s].", identifier, this.location.getFileName().orElse("?"), this.location.getLineInFile().orElse(-1));
    }

    private boolean isBehaviorValidForOperation(Behavior behaviour) {
        String baseErrorMessage = this.getBaseErrorMessage() + " This component does not allow definition of";
        if (behaviour instanceof MockBehavior && !behaviour.getEvent().isPresent()) {
            return true;
        }
        if (FLOW_REF.equals(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return true;
        }
        if (!this.isBehaviorValidForCommonNotAllowedElements(behaviour, baseErrorMessage)) {
            return false;
        }
        if (SPECIAL_CORE_OPERATIONS.contains(this.location.getComponentIdentifier().getIdentifier().toString())) {
            return this.isBehaviorValidForSpecialCoreOperations(behaviour, baseErrorMessage);
        }
        return true;
    }

    private boolean isBehaviorValidForSpecialCoreOperations(Behavior behaviour, String baseErrorMessage) {
        String identifier = this.location.getComponentIdentifier().getIdentifier().toString();
        if (SET_PAYLOAD.equals(identifier)) {
            return this.isBehaviorValidForSetPayload(behaviour, baseErrorMessage);
        }
        return this.isBehaviorValidForSetVariable(behaviour, baseErrorMessage);
    }

    private boolean isBehaviorValidForSetPayload(Behavior behaviour, String baseErrorMessage) {
        Event event = behaviour.getEvent().orElseThrow(IllegalArgumentException::new);
        if (behaviour instanceof CallBehaviour) {
            Event input = ((CallBehaviour)behaviour).getInput().orElseThrow(IllegalArgumentException::new);
            if (!this.equals(input.getAttributes(), event.getAttributes())) {
                this.logger.error(baseErrorMessage + " attributes.");
                return false;
            }
            if (!this.equals(input.getVariables(), event.getVariables())) {
                this.logger.error(baseErrorMessage + " variables.");
                return false;
            }
        } else {
            if (!this.equals(event.getAttributes(), null)) {
                this.logger.error(baseErrorMessage + " attributes.");
                return false;
            }
            if (!this.equals(event.getVariables(), null)) {
                this.logger.error(baseErrorMessage + " variables.");
                return false;
            }
        }
        return true;
    }

    private boolean isBehaviorValidForSetVariable(Behavior behaviour, String baseErrorMessage) {
        Event event = behaviour.getEvent().orElseThrow(IllegalArgumentException::new);
        if (behaviour instanceof CallBehaviour) {
            Event input = ((CallBehaviour)behaviour).getInput().orElseThrow(IllegalArgumentException::new);
            if (!this.equals(input.getAttributes(), event.getAttributes())) {
                this.logger.error(baseErrorMessage + " attributes.");
                return false;
            }
            if (!this.equals(input.getPayload(), event.getPayload())) {
                this.logger.error(baseErrorMessage + " payload.");
                return false;
            }
        } else {
            if (!this.equals(event.getAttributes(), null)) {
                this.logger.error(baseErrorMessage + " attributes.");
                return false;
            }
            if (!this.equals(event.getPayload(), null)) {
                this.logger.error(baseErrorMessage + " payload.");
                return false;
            }
        }
        return true;
    }

    private boolean isBehaviorValidForCommonNotAllowedElements(Behavior behaviour, String baseErrorMessage) {
        Event event = behaviour.getEvent().orElseThrow(IllegalArgumentException::new);
        if (!this.equals(event.getSessionProperties(), null)) {
            this.logger.error(baseErrorMessage + " session properties.");
            return false;
        }
        if (!this.equals(event.getOutboundProperties(), null)) {
            this.logger.error(baseErrorMessage + " outbound properties.");
            return false;
        }
        if (!this.equals(event.getInboundProperties(), null)) {
            this.logger.error(baseErrorMessage + " inbound properties.");
            return false;
        }
        if (!this.equals(event.getInboundAttachments(), null)) {
            this.logger.error(baseErrorMessage + " inbound attachments.");
            return false;
        }
        if (!this.equals(event.getOutboundAttachments(), null)) {
            this.logger.error(baseErrorMessage + " outbound attachments.");
            return false;
        }
        return true;
    }

    private boolean equals(Payload first, Payload second) {
        return Objects.equals(first, second) || first == null && second.getValue() instanceof NullObject || second == null && first.getValue() instanceof NullObject;
    }

    private boolean equals(EventAttributes first, EventAttributes second) {
        return Objects.equals(first, second) || first == null && second.getValue() instanceof NullObject || second == null && first.getValue() instanceof NullObject;
    }

    private <T> boolean equals(Collection<T> first, Collection<T> second) {
        return Objects.equals(first, second) || first == null && second.isEmpty() || second == null && first.isEmpty();
    }
}

