/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.api.event.DataTypeBuilder;
import org.mule.munit.common.api.event.MessageBuilderDecorator;
import org.mule.munit.common.api.model.Event;
import org.mule.munit.common.api.model.EventAttributes;
import org.mule.munit.common.api.model.NullObject;
import org.mule.munit.common.api.model.Payload;
import org.mule.munit.common.api.model.TypedKeyValue;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.privileged.interception.InternalInterceptionEvent;

public class InterceptingEventBuilder {
    public InterceptionEvent build(InterceptionEvent originalEvent, Event mockedEvent) {
        this.setVariables(originalEvent, mockedEvent);
        this.setSessionProperties((InternalInterceptionEvent)originalEvent, mockedEvent);
        originalEvent.message(this.buildMessage(originalEvent.getMessage(), mockedEvent));
        return originalEvent;
    }

    private void setVariables(InterceptionEvent originalEvent, Event mockedEvent) {
        if (null != mockedEvent.getVariables()) {
            mockedEvent.getVariables().forEach(v -> originalEvent.addVariable(v.getKey(), v.getValue(), DataTypeBuilder.fromTypedKeyValue((TypedKeyValue)v).build()));
        }
    }

    private void setSessionProperties(InternalInterceptionEvent originalEvent, Event mockedEvent) {
        if (null != mockedEvent.getSessionProperties()) {
            mockedEvent.getSessionProperties().forEach(p -> originalEvent.getSession().setProperty(p.getKey(), p.getValue(), DataTypeBuilder.fromTypedKeyValue((TypedKeyValue)p).build()));
        }
    }

    private TypedValue getAttributes(EventAttributes mockedAttributes) {
        DataTypeParamsBuilder dataTypeParamsBuilder = DataType.builder().fromObject(mockedAttributes.getValue());
        if (StringUtils.isNotBlank((CharSequence)mockedAttributes.getMediaType())) {
            dataTypeParamsBuilder.mediaType(mockedAttributes.getMediaType());
        }
        dataTypeParamsBuilder.charset(mockedAttributes.getEncoding());
        return new TypedValue(mockedAttributes.getValue(), dataTypeParamsBuilder.build());
    }

    private Message buildMessage(Message originalMessage, Event mockedEvent) {
        boolean mockedAttributesExists;
        MessageBuilderDecorator builder = new MessageBuilderDecorator(originalMessage);
        Payload mockedEventPayload = mockedEvent.getPayload();
        EventAttributes mockedAttributes = mockedEvent.getAttributes();
        boolean mockedEventPayloadExists = mockedEventPayload != null && !(mockedEventPayload.getValue() instanceof NullObject);
        boolean bl = mockedAttributesExists = mockedAttributes != null && !(mockedAttributes.getValue() instanceof NullObject);
        if (mockedEventPayloadExists) {
            builder.withPayload(mockedEventPayload.getValue());
            if (!mockedAttributesExists) {
                builder.withAttributes(TypedValue.of(null));
            }
            if (mockedEventPayload.getMediaType() != null) {
                MediaType mediaType = MediaType.parse((String)mockedEventPayload.getMediaType());
                if (mockedEventPayload.getEncoding() != null) {
                    mediaType = mediaType.withCharset(Charset.forName(mockedEventPayload.getEncoding()));
                }
                builder.withMediaType(mediaType);
            }
        }
        if (mockedAttributesExists) {
            TypedValue typedValueAttributes = this.getAttributes(mockedAttributes);
            builder.withAttributes(typedValueAttributes);
            if (!mockedEventPayloadExists) {
                builder.withPayload(null);
            }
        }
        if (null != mockedEvent.getInboundProperties()) {
            mockedEvent.getInboundProperties().forEach(p -> builder.withInboundProperty(p.getKey(), (Object)p.getValue(), p.getMediaType(), p.getEncoding()));
        }
        if (null != mockedEvent.getOutboundProperties()) {
            mockedEvent.getOutboundProperties().forEach(p -> builder.withOutboundProperty(p.getKey(), (Object)p.getValue(), p.getMediaType(), p.getEncoding()));
        }
        if (null != mockedEvent.getInboundAttachments()) {
            mockedEvent.getInboundAttachments().forEach(a -> builder.withInboundAttachment(a.getKey(), a.getDataHandler()));
        }
        if (null != mockedEvent.getOutboundAttachments()) {
            mockedEvent.getOutboundAttachments().forEach(a -> builder.withOutboundAttachment(a.getKey(), a.getDataHandler()));
        }
        return builder.build();
    }
}

