/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.api.event.DataTypeBuilder;
import org.mule.munit.common.api.event.MessageBuilderDecorator;
import org.mule.munit.common.api.model.Event;
import org.mule.munit.common.api.model.EventAttributes;
import org.mule.munit.common.api.model.NullObject;
import org.mule.munit.common.api.model.Payload;
import org.mule.munit.common.api.model.TypedKeyValue;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class InterceptingEventBuilder {
    public InterceptionEvent build(InterceptionEvent originalEvent, Event mockedEvent) {
        this.setVariables(originalEvent, mockedEvent);
        originalEvent.message(this.buildMessage(originalEvent.getMessage(), mockedEvent));
        return originalEvent;
    }

    private void setVariables(InterceptionEvent originalEvent, Event mockedEvent) {
        if (null != mockedEvent.getVariables()) {
            mockedEvent.getVariables().forEach(v -> originalEvent.addVariable(v.getKey(), v.getValue(), DataTypeBuilder.fromTypedKeyValue((TypedKeyValue)v).build()));
        }
    }

    private TypedValue getAttributes(EventAttributes mockedAttributes) {
        DataTypeParamsBuilder dataTypeParamsBuilder = DataType.builder().fromObject(mockedAttributes.getValue());
        if (StringUtils.isNotBlank((CharSequence)mockedAttributes.getMediaType())) {
            dataTypeParamsBuilder.mediaType(mockedAttributes.getMediaType());
        }
        dataTypeParamsBuilder.charset(mockedAttributes.getEncoding());
        return new TypedValue(mockedAttributes.getValue(), dataTypeParamsBuilder.build());
    }

    private Message buildMessage(Message originalMessage, Event mockedEvent) {
        boolean mockedAttributesExists;
        MessageBuilderDecorator builder = new MessageBuilderDecorator(originalMessage);
        Payload mockedEventPayload = mockedEvent.getPayload();
        EventAttributes mockedAttributes = mockedEvent.getAttributes();
        boolean mockedEventPayloadExists = mockedEventPayload != null && !(mockedEventPayload.getValue() instanceof NullObject);
        boolean bl = mockedAttributesExists = mockedAttributes != null && !(mockedAttributes.getValue() instanceof NullObject);
        if (mockedEventPayloadExists) {
            builder.withPayload(mockedEventPayload.getValue());
            if (!mockedAttributesExists) {
                builder.withAttributes(TypedValue.of(null));
            }
            if (mockedEventPayload.getMediaType() != null) {
                MediaType mediaType = MediaType.parse((String)mockedEventPayload.getMediaType());
                if (mockedEventPayload.getEncoding() != null) {
                    mediaType = mediaType.withCharset(Charset.forName(mockedEventPayload.getEncoding()));
                }
                builder.withMediaType(mediaType);
            }
        }
        if (mockedAttributesExists) {
            TypedValue typedValueAttributes = this.getAttributes(mockedAttributes);
            builder.withAttributes(typedValueAttributes);
            if (!mockedEventPayloadExists) {
                builder.withPayload(null);
            }
        }
        return builder.build();
    }
}

