/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.behavior;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.mock.behavior.Behavior;
import org.mule.munit.mock.behavior.SpyBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBehaviorManager
implements BehaviorManager {
    public static String ID = "_munitBehaviorManager";
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<ProcessorCall> calls = new CopyOnWriteArrayList<ProcessorCall>();
    protected List<Behavior> behaviors = new ArrayList<Behavior>();
    protected List<SpyBehavior> beforeCallProcessorSpies = new CopyOnWriteArrayList<SpyBehavior>();
    protected List<SpyBehavior> afterCallProcessorSpies = new CopyOnWriteArrayList<SpyBehavior>();

    public void reset() {
        this.calls.clear();
        this.behaviors.clear();
        this.beforeCallProcessorSpies.clear();
        this.afterCallProcessorSpies.clear();
    }

    public synchronized void addBehavior(Behavior behavior) {
        this.behaviors.add(behavior);
    }

    public synchronized void addCall(ProcessorCall call) {
        this.calls.add(call);
    }

    public synchronized void addBeforeCallSpyBehavior(SpyBehavior spyBehavior) {
        this.beforeCallProcessorSpies.add(spyBehavior);
    }

    public synchronized void addAfterCallSpyBehavior(SpyBehavior spyBehavior) {
        this.afterCallProcessorSpies.add(spyBehavior);
    }

    public Optional<Behavior> getBetterMatchingBehavior(ProcessorCall processorCall) {
        return this.getBetterMatchingAction(processorCall, this.behaviors);
    }

    public List<ProcessorCall> findCallsFor(ProcessorId mpId, Map<String, Object> attributesMatchers) {
        this.logger.debug("Finding calls for message processor: " + mpId.getFullName());
        ArrayList<ProcessorCall> expected = new ArrayList<ProcessorCall>();
        ProcessorCall matchingCall = new ProcessorCall(mpId);
        matchingCall.setAttributes(attributesMatchers);
        for (ProcessorCall call : this.calls) {
            if (matchingCall.matchingWeight(call) < 0) continue;
            expected.add(call);
        }
        return expected;
    }

    public Optional<SpyBehavior> getBetterMatchingBeforeSpyBehavior(ProcessorCall processorCall) {
        this.logger.debug("Finding Spy Before for: " + processorCall.getProcessorId().getFullName());
        return this.getBetterMatchingAction(processorCall, this.beforeCallProcessorSpies);
    }

    public Optional<SpyBehavior> getBetterMatchingAfterSpyBehavior(ProcessorCall processorCall) {
        this.logger.debug("Finding Spy After for: " + processorCall.getProcessorId().getFullName());
        return this.getBetterMatchingAction(processorCall, this.afterCallProcessorSpies);
    }

    private <T extends Behavior> Optional<T> getBetterMatchingAction(ProcessorCall processorCall, Collection<T> actions) {
        AbstractMap.SimpleEntry bestMatchingBehavior = new AbstractMap.SimpleEntry(0, Optional.empty());
        for (Behavior behavior : actions) {
            int matchingWeight = behavior.getProcessorCall().matchingWeight(processorCall);
            if (matchingWeight < 0 || matchingWeight < (Integer)bestMatchingBehavior.getKey()) continue;
            bestMatchingBehavior.setValue(Optional.of(behavior));
        }
        return (Optional)bestMatchingBehavior.getValue();
    }
}

