/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.server.MunitCoverageServer;
import org.mule.munit.remote.CoverageManager;
import org.mule.munit.remote.RemoteRunnerNotificationListener;
import org.mule.munit.runner.mule.MunitSuiteRunner;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.munit.runner.mule.result.notification.NotificationListenerDecorator;
import org.mule.munit.runner.mule.result.notification.StreamNotificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitRemoteRunner {
    public static final String PORT_PARAMETER = "-port";
    public static final String RESOURCE_PARAMETER = "-resource";
    public static final String RUN_TOKEN_PARAMETER = "-run_token";
    public static final String TEST_NAME_PARAMETER = "-test_name";
    public static final String RESOURCES_TOKEN_SEPARATOR = ",";
    public static final String TEST_NAME_TOKEN_SEPARATOR = "<";
    public static final String MUNIT_PROJECT_NAME_SYSTEM_PROPERTY = "munitProjectName";
    public static final String CALCULATE_COVERAGE_SYSTEM_PROPERTY = "calculate.coverage";
    public static final String APPLICATION_RESOURCES_SYSTEM_PROPERTY = "application.paths";
    protected String message;
    protected Socket requestSocket;
    protected ObjectOutputStream out;
    private Integer coveragePort;
    private MunitCoverageServer coverageServer;
    private Set<String> coveredPaths = new HashSet<String>();

    public static void main(String[] args) {
        int port = -1;
        String runToken = null;
        String resources = null;
        String testName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(RUN_TOKEN_PARAMETER)) {
                runToken = args[i + 1];
            }
            if (args[i].equalsIgnoreCase(RESOURCE_PARAMETER)) {
                resources = args[i + 1];
            }
            if (args[i].equalsIgnoreCase(PORT_PARAMETER)) {
                port = Integer.valueOf(args[i + 1]);
            }
            if (!args[i].equalsIgnoreCase(TEST_NAME_PARAMETER)) continue;
            testName = args[i + 1];
        }
        MunitRemoteRunner serverRemoteRunner = new MunitRemoteRunner();
        serverRemoteRunner.run(port, runToken, resources, testName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int port, String runToken, String resources, String testName) {
        RemoteRunnerNotificationListener listener = null;
        CoverageManager coverageManager = this.buildCoverageManager();
        try {
            this.connectToStudioServer(port);
            coverageManager.startCoverageServer();
            listener = new RemoteRunnerNotificationListener(runToken, this.out);
            listener.notifyRunStart();
            List<String> testNameList = this.buildTestNamesList(testName);
            for (String resource : resources.split(RESOURCES_TOKEN_SEPARATOR)) {
                try {
                    this.runTestSuite(resource, testNameList, listener);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            coverageManager.stopCoverageServer();
            if (null != listener) {
                this.calculateCoverageIfApplicable(coverageManager, listener);
                listener.notifyRunFinish();
            }
            this.closeConnectionToStudioServer();
            System.out.println("[" + this.getClass().getName() + "]" + "Done");
        }
        catch (IOException ioException) {
            try {
                ioException.printStackTrace();
                if (null != listener) {
                    this.calculateCoverageIfApplicable(coverageManager, listener);
                    listener.notifyRunFinish();
                }
                this.closeConnectionToStudioServer();
                System.out.println("[" + this.getClass().getName() + "]" + "Done");
            }
            catch (Throwable throwable) {
                if (null != listener) {
                    this.calculateCoverageIfApplicable(coverageManager, listener);
                    listener.notifyRunFinish();
                }
                this.closeConnectionToStudioServer();
                System.out.println("[" + this.getClass().getName() + "]" + "Done");
                throw throwable;
            }
        }
        System.exit(0);
    }

    private List<String> buildTestNamesList(String testNames) {
        List<Object> testNameList = StringUtils.isNotBlank((String)testNames) ? Arrays.asList(testNames.split(TEST_NAME_TOKEN_SEPARATOR)) : new ArrayList();
        return testNameList;
    }

    private void connectToStudioServer(int port) throws IOException {
        this.requestSocket = new Socket("localhost", port);
        System.out.println("[" + this.getClass().getName() + "]" + "Connected to localhost in port " + port);
        this.out = new ObjectOutputStream(this.requestSocket.getOutputStream());
        this.out.flush();
    }

    private void closeConnectionToStudioServer() {
        try {
            if (null != this.out) {
                this.out.close();
            }
            if (null != this.requestSocket) {
                this.requestSocket.close();
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private CoverageManager buildCoverageManager() {
        Boolean shouldCalculateCoverage = Boolean.valueOf(System.getProperty(CALCULATE_COVERAGE_SYSTEM_PROPERTY));
        if (!shouldCalculateCoverage.booleanValue()) {
            return new CoverageManager(-1, "", false, this.getProjectName());
        }
        String coberturaPort = System.getProperty("cobertura.port");
        String applicationResources = System.getProperty(APPLICATION_RESOURCES_SYSTEM_PROPERTY);
        System.out.println("Cobertura port: " + coberturaPort + " resources: " + applicationResources);
        return new CoverageManager(Integer.valueOf(coberturaPort), applicationResources, true, this.getProjectName());
    }

    private void calculateCoverageIfApplicable(CoverageManager coverageManager, RemoteRunnerNotificationListener listener) {
        ApplicationCoverageReport coverageReport = coverageManager.generateCoverageReport();
        if (null != listener) {
            String coverageReportJson = new JSONObject((Object)coverageReport).toString();
            listener.notifyCoverageReport(coverageReportJson);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runTestSuite(String resource, List<String> testNames, RemoteRunnerNotificationListener listener) {
        MunitSuiteRunner runner;
        String suitePath = FilenameUtils.getPath((String)resource);
        String suiteName = FilenameUtils.getName((String)resource);
        listener.defineCurrentSuite(suitePath, suiteName);
        try {
            runner = new MunitSuiteRunner(resource, testNames, this.getProjectName());
            runner.setNotificationListener((NotificationListener)this.buildListenerDecorator(listener));
            listener.notifySuiteStart();
            listener.notifyNumberOfTest(runner.getNumberOfTests());
        }
        catch (RuntimeException e) {
            listener.notifySuiteStartFailure(new Notification(e.getMessage(), MunitTest.stack2string((Throwable)e)));
            throw e;
        }
        try {
            runner.run();
        }
        finally {
            listener.notifySuiteFinished();
            return runner.getNumberOfTests();
        }
    }

    private NotificationListenerDecorator buildListenerDecorator(NotificationListener listener) {
        NotificationListenerDecorator listenerDecorator = new NotificationListenerDecorator();
        listenerDecorator.addNotificationListener(listener);
        listenerDecorator.addNotificationListener((NotificationListener)new StreamNotificationListener(System.out));
        return listenerDecorator;
    }

    private String getProjectName() {
        return System.getProperty(MUNIT_PROJECT_NAME_SYSTEM_PROPERTY);
    }
}

