/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote;

import org.apache.commons.lang.Validate;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.CoverageReportBuilder;
import org.mule.munit.plugins.coverage.report.SingleRunReport;
import org.mule.munit.plugins.coverage.server.MunitCoverageServer;
import org.mule.munit.plugins.coverage.server.ReportAccumulator;
import org.mule.munit.remote.path.ApplicationPathBuilder;

import java.util.HashSet;
import java.util.Set;

public class CoverageManager implements ReportAccumulator {

    private Integer coveragePort;
    private MunitCoverageServer coverageServer;

    private String applicationResources;

    private boolean shouldCalculateCoverage;

    private Set<String> coveredPaths = new HashSet<String>();

    private ApplicationCoverageReport coverageReport = new ApplicationCoverageReport();

    private String projectName;

    private Set<String> ignoreFlows = new HashSet<String>();

    public CoverageManager(Integer coveragePort, String applicationResources, boolean shouldCalculateCoverage, String projectName) {
        Validate.notNull(coveragePort, "The coverage port must not null");
        this.coveragePort = coveragePort;
        this.applicationResources = applicationResources;
        this.shouldCalculateCoverage = shouldCalculateCoverage;

        this.projectName = projectName;
    }

    public void startCoverageServer() {
        if (shouldCalculateCoverage) {
            coverageServer = new MunitCoverageServer(coveragePort, this);
            coverageServer.launch();
        }
    }

    public void stopCoverageServer() {
        if (shouldCalculateCoverage) {
            coverageServer.shutdown();
        }
    }

    @Override
    public synchronized void accumulateReport(SingleRunReport report) {
        System.out.println("[" + this.getClass().getName() + "]" + "accumulating report");
        if (report != null) {
            System.out.println("[" + this.getClass().getName() + "]" + "report is not null");
            coveredPaths.addAll(report.getCoveredPaths());
        }
    }

    public void setIgnoreFlows(Set<String> ignoreFlows) {
        this.ignoreFlows = ignoreFlows;
    }

    protected ApplicationCoverageReport generateCoverageReport() {
        if (shouldCalculateCoverage) {
            try {
                System.out.println("[" + this.getClass().getName() + "]" + "Calculating application coverage for resources: " + applicationResources);

                ApplicationPathBuilder appPathBuilder = new ApplicationPathBuilder(applicationResources, projectName);

                CoverageReportBuilder reportBuilder = new CoverageReportBuilder(applicationResources);
                reportBuilder.setFlowsToIgnore(ignoreFlows);

                coverageReport = reportBuilder.buildReport(coveredPaths, appPathBuilder.getFlowPaths(), appPathBuilder.getSubFlowPaths(), appPathBuilder.getBatchPaths());
            } catch (Throwable e) {
                System.out.println("[" + this.getClass().getName() + "]" + "Coverage report calculation failed  - ");
                e.printStackTrace();
            }
        }

        return coverageReport;
    }


}
