package org.mule.munit.remote.notification;

import java.util.ArrayList;
import java.util.List;

public class MessageHandlerContainer implements MessageHandler {

    private List<MessageHandler> messageHandlers = new ArrayList<MessageHandler>();

    public void handle(String message) {
        for (MessageHandler messageHandler : messageHandlers) {
            messageHandler.handle(message);
        }
    }

    public void addMessageHandler(MessageHandler messageHandler) {
        messageHandlers.add(messageHandler);
    }
}
