/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONObject;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.remote.CoverageManager;
import org.mule.munit.remote.config.RunConfiguration;
import org.mule.munit.remote.config.RunConfigurationBuilder;
import org.mule.munit.remote.listener.MessageBuilderEventListener;
import org.mule.munit.remote.listener.RemoteRunnerEventListener;
import org.mule.munit.remote.notification.ConsoleMessageHandler;
import org.mule.munit.remote.notification.MessageHandlerContainer;
import org.mule.munit.remote.notification.MessageHandlerMode;
import org.mule.munit.remote.notification.SocketMessageHandler;
import org.mule.munit.runner.mule.SuiteRunner;
import org.mule.munit.runner.mule.result.notification.StreamSuiteRunnerEventListener;
import org.mule.munit.runner.mule.result.notification.SuiteRunnerEventListener;
import org.mule.munit.runner.mule.result.notification.SuiteRunnerEventListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRunner {
    public static void main(String[] args) throws ParseException, IOException {
        RunConfiguration runConfig = new RunConfigurationBuilder(args).build();
        RemoteRunner runner = new RemoteRunner();
        runner.run(runConfig);
        RemoteRunner.shutDown();
    }

    public void run(RunConfiguration runConfig) throws IOException {
        System.out.println("[" + this.getClass().getName() + "]Run Started");
        CoverageManager coverageManager = this.buildCoverageManager(runConfig);
        coverageManager.startCoverageServer();
        MessageBuilderEventListener listener = this.buildRunnerListener(runConfig);
        listener.notifyRunStart();
        List<String> testNameList = runConfig.getTestList();
        for (String munitSuite : runConfig.getSuiteList()) {
            try {
                this.runTestSuite(munitSuite, testNameList, runConfig.getProjectName(), listener);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        listener.notifyRunFinish();
        coverageManager.stopCoverageServer();
        this.calculateCoverageIfApplicable(coverageManager, listener);
        System.out.println("[" + this.getClass().getName() + "]Done");
    }

    private void runTestSuite(String munitSuite, List<String> testNames, String projectName, MessageBuilderEventListener listener) {
        String suitePath = FilenameUtils.getFullPath((String)munitSuite);
        String suiteName = FilenameUtils.getName((String)munitSuite);
        listener.defineCurrentSuite(suitePath, suiteName);
        SuiteRunner runner = new SuiteRunner(munitSuite, testNames, projectName, this.buildListenerContainer(listener));
        runner.run();
    }

    private CoverageManager buildCoverageManager(RunConfiguration runConfig) {
        CoverageManager coverageManager;
        boolean shouldCalculateCoverage = runConfig.isRunCoverage();
        String projectName = runConfig.getProjectName();
        if (!shouldCalculateCoverage) {
            coverageManager = new CoverageManager(-1, "", false, projectName);
        } else {
            int coveragePort = runConfig.getCoveragePort();
            System.setProperty("cobertura.port", String.valueOf(coveragePort));
            String applicationResources = runConfig.getApplicationPaths();
            System.out.format("Coverage port: %d resources: %s \n", coveragePort, applicationResources);
            coverageManager = new CoverageManager(coveragePort, applicationResources, true, projectName);
            coverageManager.setIgnoreFlows(runConfig.getIgnoreFlows());
        }
        return coverageManager;
    }

    private SuiteRunnerEventListener buildListenerContainer(SuiteRunnerEventListener listener) {
        SuiteRunnerEventListenerContainer listenerDecorator = new SuiteRunnerEventListenerContainer();
        listenerDecorator.addNotificationListener(listener);
        listenerDecorator.addNotificationListener((SuiteRunnerEventListener)new StreamSuiteRunnerEventListener(System.out));
        return listenerDecorator;
    }

    private MessageBuilderEventListener buildRunnerListener(RunConfiguration runConfig) throws IOException {
        MessageHandlerContainer messageHandlerContainer = new MessageHandlerContainer();
        for (String notifier : runConfig.getNotifiers()) {
            if (MessageHandlerMode.CONSOLE.toString().equals(notifier.toLowerCase())) {
                messageHandlerContainer.addMessageHandler(new ConsoleMessageHandler());
                continue;
            }
            if (MessageHandlerMode.SOCKET.toString().equals(notifier.toLowerCase())) {
                messageHandlerContainer.addMessageHandler(new SocketMessageHandler(runConfig.getPort()));
                continue;
            }
            System.out.format("Mode '%s' does not exist\n", notifier);
        }
        return new MessageBuilderEventListener(runConfig.getRunToken(), messageHandlerContainer);
    }

    private void calculateCoverageIfApplicable(CoverageManager coverageManager, RemoteRunnerEventListener listener) {
        ApplicationCoverageReport coverageReport = coverageManager.generateCoverageReport();
        String coverageReportJson = new JSONObject((Object)coverageReport).toString();
        listener.notifyCoverageReport(coverageReportJson);
    }

    private static void shutDown() {
        System.exit(0);
    }
}

