package org.mule.munit.remote.notification;

import org.mule.munit.runner.remote.RemoteRunnerMessage;

/**
 * Notifier that prints protocol in the standard output in one single line
 */
public class ConsoleMessageHandler implements MessageHandler {

    public static final String NEW_LINE_ESCAPE_TOKEN = new String(new byte[]{0x1a});

    public void handle(String message) {
        String singleLineMessage = message.replaceAll("[\r\n]+", NEW_LINE_ESCAPE_TOKEN);
        System.out.println(RemoteRunnerMessage.FIELD_TOKEN + singleLineMessage);
    }
}
