/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.remote.config.RunConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunConfigurationBuilder {
    public static final String SUITES_ENV = "munit.suites";
    public static final String SUITES_PARAMETER = "suites";
    public static final String RUN_TOKEN_PARAMETER = "run_token";
    public static final String TEST_NAME_PARAMETER = "test_name";
    public static final String NOTIFIERS_PARAMETER = "mode";
    public static final String PORT_PARAMETER = "port";
    public static final String RUN_COVERAGE_PARAMETER = "run_coverage";
    public static final String COVERAGE_PORT_PARAMETER = "coverage_port";
    public static final String PROJECT_NAME_PARAMETER = "project_name";
    public static final String APPLICATION_PATHS_PARAMETER = "application_paths";
    public static final String IGNORE_FLOWS_PARAMETER = "ignore_flows";
    public static final String SUITES_TOKEN_SEPARATOR = ",";
    public static final String NOTIFIERS_TOKEN_SEPARATOR = ",";
    public static final String IGNORE_FLOWS_TOKEN_SEPARATOR = ",";
    public static final String TESTS_TOKEN_SEPARATOR = "<";
    private static final int MIN_PORT_NUMBER = 50000;
    private static final int MAX_PORT_NUMBER = 55000;
    private String[] args = new String[0];
    private Options options = new Options();
    private CommandLineParser parser = new BasicParser();

    public RunConfigurationBuilder(String[] args) {
        this.configureOptions();
        this.args = args;
    }

    private void configureOptions() {
        this.options.addOption(this.createOption(SUITES_PARAMETER, true, "MUnit suites to be run", false));
        this.options.addOption(this.createOption(RUN_TOKEN_PARAMETER, true, "Run Token", true));
        this.options.addOption(this.createOption(PORT_PARAMETER, "Port to handle suite results"));
        this.options.addOption(this.createOption(NOTIFIERS_PARAMETER, "Mode to handle suite results"));
        this.options.addOption(this.createOption(TEST_NAME_PARAMETER, "Test to be run"));
        this.options.addOption(this.createOption(RUN_COVERAGE_PARAMETER, false, "Whether is has to run coverage", false));
        this.options.addOption(this.createOption(PROJECT_NAME_PARAMETER, "Name of the project"));
        this.options.addOption(this.createOption(APPLICATION_PATHS_PARAMETER, "Application files to be covered"));
        this.options.addOption(this.createOption(COVERAGE_PORT_PARAMETER, "Port for coverage server"));
        this.options.addOption(this.createOption(IGNORE_FLOWS_PARAMETER, "Flows to ignore when running coverage"));
    }

    public RunConfiguration build() throws ParseException {
        CommandLine cmdLine = this.parser.parse(this.options, this.args);
        RunConfiguration runConfig = new RunConfiguration();
        runConfig.setSuiteList(this.buildSuiteList(cmdLine));
        runConfig.setTestList(this.buildTestList(cmdLine));
        runConfig.setNotifiers(this.buildNotifiersList(cmdLine));
        runConfig.setRunToken(cmdLine.getOptionValue(RUN_TOKEN_PARAMETER));
        runConfig.setRunCoverage(cmdLine.hasOption(RUN_COVERAGE_PARAMETER));
        runConfig.setProjectName(cmdLine.getOptionValue(PROJECT_NAME_PARAMETER));
        if (cmdLine.hasOption(PORT_PARAMETER)) {
            runConfig.setPort(Integer.parseInt(cmdLine.getOptionValue(PORT_PARAMETER)));
        }
        if (runConfig.isRunCoverage()) {
            this.buildCoverageConfiguration(cmdLine, runConfig);
        }
        return runConfig;
    }

    private Option createOption(String name, String description) {
        return this.createOption(name, true, description, false);
    }

    private Option createOption(String name, boolean hasArg, String description, boolean required) {
        OptionBuilder.withDescription((String)description);
        OptionBuilder.hasArg((boolean)hasArg);
        OptionBuilder.isRequired((boolean)required);
        return OptionBuilder.create((String)name);
    }

    private List<String> buildSuiteList(CommandLine cmd) {
        String suitesParam = cmd.getOptionValue(SUITES_PARAMETER, "");
        if (suitesParam.equals("") && this.getenv(SUITES_ENV) != null) {
            suitesParam = this.getenv(SUITES_ENV);
        }
        return Arrays.asList(StringUtils.split((String)suitesParam, (String)","));
    }

    private List<String> buildNotifiersList(CommandLine cmd) {
        String suitesParam = cmd.getOptionValue(NOTIFIERS_PARAMETER, "");
        return Arrays.asList(StringUtils.split((String)suitesParam, (String)","));
    }

    private Set<String> buildIgnoreFlowsList(CommandLine cmd) {
        String flowsParam = cmd.getOptionValue(IGNORE_FLOWS_PARAMETER, "");
        return new HashSet<String>(Arrays.asList(StringUtils.split((String)flowsParam, (String)",")));
    }

    private List<String> buildTestList(CommandLine cmd) {
        String testNames = cmd.getOptionValue(TEST_NAME_PARAMETER, "");
        if (StringUtils.isEmpty((String)testNames)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(testNames.split(TESTS_TOKEN_SEPARATOR));
    }

    private void buildCoverageConfiguration(CommandLine cmdLine, RunConfiguration runConfig) {
        Integer coveragePort;
        runConfig.setApplicationPaths(cmdLine.getOptionValue(APPLICATION_PATHS_PARAMETER));
        if (cmdLine.hasOption(COVERAGE_PORT_PARAMETER)) {
            coveragePort = Integer.parseInt(cmdLine.getOptionValue(COVERAGE_PORT_PARAMETER));
        } else {
            FreePortFinder portFinder = new FreePortFinder(50000, 55000);
            coveragePort = portFinder.find();
        }
        runConfig.setCoveragePort(coveragePort);
        runConfig.setIgnoreFlows(this.buildIgnoreFlowsList(cmdLine));
    }

    String getenv(String key) {
        return System.getenv(key);
    }
}

