package org.mule.munit.remote.notification;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;

/**
 * Notifier that writes protocol through a socket
 */
public class SocketMessageHandler implements MessageHandler {

    private Socket requestSocket;
    private ObjectOutputStream out;


    public SocketMessageHandler(int port) throws IOException{
        requestSocket = new Socket("localhost", port);
        out = new ObjectOutputStream(requestSocket.getOutputStream());
        System.out.println("[" + this.getClass().getName() + "]" + "Connected to localhost in port " + port);
    }

    public void handle(String message) {
        try {
            out.writeObject(message);
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
