/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.listener;

import org.apache.commons.lang.Validate;
import org.mule.munit.remote.MessageBuilder;
import org.mule.munit.remote.listener.RemoteRunnerEventListener;
import org.mule.munit.remote.notification.MessageHandler;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.mule.result.notification.SuiteRunnerEventListener;

public class MessageBuilderEventListener
implements RemoteRunnerEventListener,
SuiteRunnerEventListener {
    private MessageHandler notifier;
    private String runToken;
    private String suitePath;
    private String suiteName;

    public MessageBuilderEventListener(String runToken, MessageHandler notifier) {
        Validate.notNull((Object)notifier, (String)"The notifier can not be null");
        Validate.notEmpty((String)runToken, (String)"The run token can not be null nor empty");
        this.notifier = notifier;
        this.runToken = runToken;
    }

    public synchronized void defineCurrentSuite(String suitePath, String suiteName) {
        Validate.notEmpty((String)suitePath, (String)"The suite path can not be null nor empty");
        Validate.notEmpty((String)suiteName, (String)"The suite name can not be null nor empty");
        this.suitePath = suitePath;
        this.suiteName = suiteName;
    }

    public void notifyRunStart() {
        String message = MessageBuilder.runStartMessage(this.runToken);
        this.sendMessage(message);
    }

    public void notifySuiteStart(String suite) {
        String message = MessageBuilder.testSuiteStartMessage(this.runToken, this.suitePath, this.suiteName);
        this.sendMessage(message);
    }

    public void notifySuiteStartFailure(Notification notification) {
        String message = MessageBuilder.testSuiteStartFailureMessage(this.runToken, this.suitePath, this.suiteName, notification.getFullMessage());
        this.sendMessage(message);
    }

    public void notifyNumberOfTests(int numberOfTests) {
        String message = MessageBuilder.numberOfTestsMessage(this.runToken, this.suitePath, this.suiteName, String.valueOf(numberOfTests));
        this.sendMessage(message);
    }

    public void notifyTestStart(MunitTest test) {
        String message = MessageBuilder.testStartMessage(this.runToken, this.suitePath, this.suiteName, test.getName());
        this.sendMessage(message);
    }

    public void notifyTestResult(TestResult testResult) {
        String message = testResult.getError() != null ? MessageBuilder.testErrorMessage(this.runToken, this.suitePath, this.suiteName, testResult.getTestName(), testResult.getError().getFullMessage()) : (testResult.getFailure() != null ? MessageBuilder.testFailureMessage(this.runToken, this.suitePath, this.suiteName, testResult.getTestName(), testResult.getFailure().getFullMessage()) : MessageBuilder.testFinishedMessage(this.runToken, this.suitePath, this.suiteName, testResult.getTestName()));
        this.sendMessage(message);
    }

    public void notifyTestIgnored(TestResult testResult) {
        String message = MessageBuilder.testIgnoredMessage(this.runToken, this.suitePath, this.suiteName, testResult.getName());
        this.sendMessage(message);
    }

    public void notifySuiteEnd(SuiteResult result) {
        String message = MessageBuilder.testSuiteFinishedMessage(this.runToken, this.suitePath, this.suiteName);
        this.sendMessage(message);
    }

    public void notifyBeforeSuiteFailure(Notification notification) {
        String message = MessageBuilder.beforeSuiteFailureMessage(this.runToken, this.suitePath, this.suiteName, notification.getFullMessage());
        this.sendMessage(message);
    }

    public void notifyBeforeSuiteError(Notification notification) {
        String message = MessageBuilder.beforeSuiteErrorMessage(this.runToken, this.suitePath, this.suiteName, notification.getFullMessage());
        this.sendMessage(message);
    }

    public void notifyAfterSuiteFailure(Notification notification) {
        String message = MessageBuilder.afterSuiteFailureMessage(this.runToken, this.suitePath, this.suiteName, notification.getFullMessage());
        this.sendMessage(message);
    }

    public void notifyAfterSuiteError(Notification notification) {
        String message = MessageBuilder.afterSuiteErrorMessage(this.runToken, this.suitePath, this.suiteName, notification.getFullMessage());
        this.sendMessage(message);
    }

    public void notifyCoverageReport(String coverageReportJson) {
        String message = MessageBuilder.notifyCoverageReportMessage(this.runToken, coverageReportJson);
        this.sendMessage(message);
    }

    public void notifyRunFinish() {
        String message = MessageBuilder.runFinishedMessage(this.runToken);
        this.sendMessage(message);
    }

    private void sendMessage(String message) {
        this.notifier.handle(message);
    }
}

