package org.mule.munit.remote.config;

import org.apache.commons.lang3.Validate;

import java.util.List;
import java.util.Set;

/**
 * Class that has all the required information to run a suite
 */
public class RunConfiguration {

    private List<String> suiteList;
    private List<String> testList;
    private List<String> notifiers;
    private String runToken;
    private boolean runCoverage;
    private int coveragePort;
    private int port;
    private String applicationPaths;
    private String projectName;
    private Set<String> ignoreFlows;

    public List<String> getSuiteList() {
        return suiteList;
    }

    public String getRunToken() {
        return runToken;
    }

    public List<String> getTestList() {
        return testList;
    }

    public int getCoveragePort() {
        return coveragePort;
    }

    public int getPort() {
        return port;
    }

    public String getApplicationPaths() {
        return applicationPaths;
    }

    public boolean isRunCoverage() {
        return runCoverage;
    }

    public String getProjectName() {
        return projectName;
    }

    public List<String> getNotifiers() {
        return notifiers;
    }

    public Set<String> getIgnoreFlows() {
        return ignoreFlows;
    }

    public void setSuiteList(List<String> suiteList) {
        Validate.notEmpty(suiteList, emptyMessage("The suite list"));
        this.suiteList = suiteList;
    }

    public void setTestList(List<String> testList) {
        this.testList = testList;
    }

    public void setRunToken(String runToken) {
        Validate.notEmpty(runToken, emptyMessage("The run token"));
        this.runToken = runToken;
    }

    public void setApplicationPaths(String applicationPaths) {
        this.applicationPaths = applicationPaths;
    }

    public void setCoveragePort(Integer coveragePort) {
        Validate.notNull(coveragePort, emptyMessage("The coverage port"));
        this.coveragePort = coveragePort;
    }

    public void setRunCoverage(Boolean runCoverage) {
        this.runCoverage = runCoverage;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setNotifiers(List<String> notifiers) {
        this.notifiers = notifiers;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Suites: " + suiteList);
        if(!testList.isEmpty()){
            sb.append("\nTest: " + testList);
        }
        sb.append("\nRun Token: " + runToken);
        sb.append("\nProject: " + projectName);
        sb.append("\nApp Paths: " + applicationPaths);
        sb.append("\nRun Coverage: " + runCoverage);

        return sb.toString();
    }

    private String emptyMessage(String param){
        return String.format("%s cannot be empty", param);
    }

    public void setIgnoreFlows(Set<String> ignoreFlows) {
        this.ignoreFlows = ignoreFlows;
    }
}
