/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.CoverageReportBuilder;
import org.mule.munit.plugins.coverage.report.SingleRunReport;
import org.mule.munit.plugins.coverage.server.MunitCoverageServer;
import org.mule.munit.plugins.coverage.server.ReportAccumulator;
import org.mule.munit.remote.path.ApplicationPathBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageManager
implements ReportAccumulator {
    private Integer coveragePort;
    private MunitCoverageServer coverageServer;
    private String applicationResources;
    private boolean shouldCalculateCoverage;
    private Set<String> coveredPaths = new HashSet<String>();
    private ApplicationCoverageReport coverageReport = new ApplicationCoverageReport();
    private String projectName;
    private Set<String> ignoreFlows = new HashSet<String>();

    public CoverageManager(Integer coveragePort, String applicationResources, boolean shouldCalculateCoverage, String projectName) {
        Validate.notNull((Object)coveragePort, (String)"The coverage port must not null");
        this.coveragePort = coveragePort;
        this.applicationResources = applicationResources;
        this.shouldCalculateCoverage = shouldCalculateCoverage;
        this.projectName = projectName;
    }

    public void startCoverageServer() {
        if (this.shouldCalculateCoverage) {
            this.coverageServer = new MunitCoverageServer(this.coveragePort, (ReportAccumulator)this);
            this.coverageServer.launch();
        }
    }

    public void stopCoverageServer() {
        if (this.shouldCalculateCoverage) {
            this.coverageServer.shutdown();
        }
    }

    public synchronized void accumulateReport(SingleRunReport report) {
        System.out.println("[" + this.getClass().getName() + "]accumulating report");
        if (report != null) {
            System.out.println("[" + this.getClass().getName() + "]report is not null");
            this.coveredPaths.addAll(report.getCoveredPaths());
        }
    }

    public void setIgnoreFlows(Set<String> ignoreFlows) {
        this.ignoreFlows = ignoreFlows;
    }

    protected ApplicationCoverageReport generateCoverageReport() {
        if (this.shouldCalculateCoverage) {
            try {
                System.out.println("[" + this.getClass().getName() + "]Calculating application coverage for resources: " + this.applicationResources);
                ApplicationPathBuilder appPathBuilder = new ApplicationPathBuilder(this.applicationResources, this.projectName);
                CoverageReportBuilder reportBuilder = new CoverageReportBuilder();
                this.coverageReport = reportBuilder.setApplicationResources(this.applicationResources).setFlowsToIgnore(this.ignoreFlows).setCoveredPaths(this.coveredPaths).setAppFlowPaths(appPathBuilder.getFlowPaths()).setAppSubFlowPaths(appPathBuilder.getSubFlowPaths()).setAppBatchPaths(appPathBuilder.getBatchPaths()).build();
            }
            catch (Throwable e) {
                System.out.println("[" + this.getClass().getName() + "]Coverage report calculation failed  - ");
                e.printStackTrace();
            }
        }
        return this.coverageReport;
    }
}

