/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import org.mule.munit.remote.RemoteRunnerMessage;

public class MessageBuilder {
    public static final String RUN_START_MSG_ID = "0";
    public static final String TEST_SUITE_START_FAILURE_MSG_ID = "1";
    public static final String TEST_SUITE_START_MSG_ID = "2";
    public static final String NUMBER_OF_TESTS_MSG_ID = "3";
    public static final String TEST_START_MSG_ID = "4";
    public static final String TEST_FINSHED_MSG_ID = "5";
    public static final String TEST_IGNORED_MSG_ID = "6";
    public static final String TEST_FAILURE_MSG_ID = "7";
    public static final String TEST_ERROR_MSG_ID = "8";
    public static final String TEST_SUITE_FINISHED_MSG_ID = "9";
    public static final String RUN_FINISHED_MSG_ID = "10";
    public static final String COVERAGE_REPORT_MSG_ID = "11";
    public static final String BEFORE_SUITE_FAILURE_MSG_ID = "12";
    public static final String BEFORE_SUITE_ERROR_MSG_ID = "13";
    public static final String AFTER_SUITE_FAILURE_MSG_ID = "14";
    public static final String AFTER_SUITE_ERROR_MSG_ID = "15";

    public static String runStartMessage(String runToken) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(RUN_START_MSG_ID, runToken);
        return msg.build();
    }

    public static String testSuiteStartMessage(String runToken, String suitePath, String suiteName) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(TEST_SUITE_START_MSG_ID, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        return msg.build();
    }

    public static String numberOfTestsMessage(String runToken, String suitePath, String suiteName, String numberOfTests) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(NUMBER_OF_TESTS_MSG_ID, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        msg.setFreeMessage(numberOfTests);
        return msg.build();
    }

    public static String testStartMessage(String runToken, String suitePath, String suiteName, String testName) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(TEST_START_MSG_ID, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        msg.setTestName(testName);
        return msg.build();
    }

    public static String testFinishedMessage(String runToken, String suitePath, String suiteName, String testName) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(TEST_FINSHED_MSG_ID, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        msg.setTestName(testName);
        return msg.build();
    }

    public static String testIgnoredMessage(String runToken, String suitePath, String suiteName, String testName) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(TEST_IGNORED_MSG_ID, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        msg.setTestName(testName);
        return msg.build();
    }

    public static String testFailureMessage(String runToken, String suitePath, String suiteName, String testName, String stackTrace) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(TEST_FAILURE_MSG_ID, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        msg.setTestName(testName);
        msg.setStackTrace(stackTrace);
        return msg.build();
    }

    public static String testErrorMessage(String runToken, String suitePath, String suiteName, String testName, String stackTrace) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(TEST_ERROR_MSG_ID, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        msg.setTestName(testName);
        msg.setStackTrace(stackTrace);
        return msg.build();
    }

    public static String testSuiteFinishedMessage(String runToken, String suitePath, String suiteName) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(TEST_SUITE_FINISHED_MSG_ID, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        return msg.build();
    }

    public static String notifyCoverageReportMessage(String runToken, String coverageReportJson) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(COVERAGE_REPORT_MSG_ID, runToken);
        msg.setJsonMessage(coverageReportJson);
        return msg.build();
    }

    public static String runFinishedMessage(String runToken) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(RUN_FINISHED_MSG_ID, runToken);
        return msg.build();
    }

    public static String testSuiteStartFailureMessage(String runToken, String suitePath, String suiteName, String stackTrace) {
        return MessageBuilder.getStackTraceMessage(runToken, suitePath, suiteName, stackTrace, TEST_SUITE_START_FAILURE_MSG_ID);
    }

    public static String beforeSuiteFailureMessage(String runToken, String suitePath, String suiteName, String stackTrace) {
        return MessageBuilder.getStackTraceMessage(runToken, suitePath, suiteName, stackTrace, BEFORE_SUITE_FAILURE_MSG_ID);
    }

    public static String beforeSuiteErrorMessage(String runToken, String suitePath, String suiteName, String stackTrace) {
        return MessageBuilder.getStackTraceMessage(runToken, suitePath, suiteName, stackTrace, BEFORE_SUITE_ERROR_MSG_ID);
    }

    public static String afterSuiteFailureMessage(String runToken, String suitePath, String suiteName, String stackTrace) {
        return MessageBuilder.getStackTraceMessage(runToken, suitePath, suiteName, stackTrace, AFTER_SUITE_FAILURE_MSG_ID);
    }

    public static String afterSuiteErrorMessage(String runToken, String suitePath, String suiteName, String stackTrace) {
        return MessageBuilder.getStackTraceMessage(runToken, suitePath, suiteName, stackTrace, AFTER_SUITE_ERROR_MSG_ID);
    }

    protected static String getStackTraceMessage(String runToken, String suitePath, String suiteName, String stackTrace, String id) {
        RemoteRunnerMessage msg = new RemoteRunnerMessage(id, runToken);
        msg.setSuitePath(suitePath);
        msg.setSuiteName(suiteName);
        msg.setStackTrace(stackTrace);
        return msg.build();
    }
}

