/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.path;

import java.util.HashSet;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.munit.plugins.coverage.path.PathBuilder;
import org.mule.munit.runner.simple.MunitSimpleRunnerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPathCounter
implements MunitSimpleRunnerAction {
    private Set<String> flowPaths;
    private Set<String> subFlowPaths;
    private Set<String> batchPaths;
    private Boolean executed = false;

    public void execute(MuleContext context) {
        PathBuilder pathBuilder = new PathBuilder(context);
        this.flowPaths = new HashSet(pathBuilder.buildFlowPathsMap().values());
        this.subFlowPaths = new HashSet(pathBuilder.buildSubFlowPathsMap().values());
        this.batchPaths = new HashSet(pathBuilder.buildBatchPathsMap().values());
        this.executed = true;
    }

    public Set<String> getFlowPaths() {
        this.validateState();
        return this.flowPaths;
    }

    public Set<String> getSubFlowPaths() {
        this.validateState();
        return this.subFlowPaths;
    }

    public Set<String> getBatchPaths() {
        this.validateState();
        return this.batchPaths;
    }

    private void validateState() {
        if (!this.executed.booleanValue()) {
            throw new IllegalStateException("No count has been executed");
        }
    }
}

