/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.path;

import java.util.ArrayList;
import java.util.Set;
import org.mule.munit.remote.path.ApplicationPathCounter;
import org.mule.munit.runner.simple.MunitSimpleRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPathBuilder {
    public static final String COBERTURA_PORT_PROPERTY = "cobertura.port";
    private String resources;
    private Boolean executed = false;
    private ApplicationPathCounter pathCounter;
    private String projectName;
    private static final String MULE_DEBUG_ENABLE_PROPERTY = "mule.debug.enable";
    private static final String MULE_DEBUG_SUSPEND_PROPERTY = "mule.debug.suspend";
    private static final String MULE_DEBUG_PORT_PROPERTY = "mule.debug.port";

    public ApplicationPathBuilder(String resources, String projectName) {
        this.resources = resources;
        this.projectName = projectName;
    }

    public String getResources() {
        return this.resources;
    }

    public Set<String> getFlowPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getFlowPaths();
    }

    public Set<String> getSubFlowPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getSubFlowPaths();
    }

    public Set<String> getBatchPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getBatchPaths();
    }

    private void buildApplicationPaths() {
        this.executed = true;
        String originalCoveragePort = System.clearProperty(COBERTURA_PORT_PROPERTY);
        String originalDebugEnable = System.clearProperty(MULE_DEBUG_ENABLE_PROPERTY);
        String originalDebugSuspend = System.clearProperty(MULE_DEBUG_SUSPEND_PROPERTY);
        String originalDebugPort = System.clearProperty(MULE_DEBUG_PORT_PROPERTY);
        ArrayList<ApplicationPathCounter> actions = new ArrayList<ApplicationPathCounter>();
        this.pathCounter = new ApplicationPathCounter();
        actions.add(this.pathCounter);
        MunitSimpleRunner munitSimpleRunner = new MunitSimpleRunner(this.resources, actions, this.projectName);
        munitSimpleRunner.run();
        if (null != originalCoveragePort) {
            System.setProperty(COBERTURA_PORT_PROPERTY, originalCoveragePort);
        }
        if (null != originalDebugEnable) {
            System.setProperty(MULE_DEBUG_ENABLE_PROPERTY, originalDebugEnable);
        }
        if (null != originalDebugSuspend) {
            System.setProperty(MULE_DEBUG_SUSPEND_PROPERTY, originalDebugSuspend);
        }
        if (null != originalDebugPort) {
            System.setProperty(MULE_DEBUG_PORT_PROPERTY, originalDebugPort);
        }
    }
}

