/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote;

import org.apache.commons.lang.Validate;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.mule.result.notification.NotificationListener;

import java.io.IOException;
import java.io.ObjectOutput;

/**
 * @author Mulesoft Inc.
 * @since 3.6.0
 */
@Deprecated
public class RemoteRunnerNotificationListener implements NotificationListener, RunNotificationListener {

    private ObjectOutput out;

    private String runToken;

    private String suitePath;
    private String suiteName;

    public RemoteRunnerNotificationListener(String runToken, ObjectOutput out) {
        Validate.notNull(out, "The out can not be null");
        Validate.notEmpty(runToken, "The run token can not be null nor empty");

        this.out = out;
        this.runToken = runToken;
    }

    public synchronized void defineCurrentSuite(String suitePath, String suiteName) {
        Validate.notEmpty(suitePath, "The suite path can not be null nor empty");
        Validate.notEmpty(suiteName, "The suite name can not be null nor empty");

        this.suitePath = suitePath;
        this.suiteName = suiteName;
    }

    @Override
    public void notifyRunStart() {
        String message = MessageBuilder.runStartMessage(runToken);
        sendMessage(message);
    }

    @Override
    public void notifySuiteStart() {
        String message = MessageBuilder.testSuiteStartMessage(runToken, suitePath, suiteName);
        sendMessage(message);
    }

    public void notifySuiteStartFailure(Notification notification) {
        String message = MessageBuilder.testSuiteStartFailureMessage(runToken, suitePath, suiteName, notification.getFullMessage());
        sendMessage(message);
    }

    public void notifyNumberOfTest(int numberOfTests) {
        String message = MessageBuilder.numberOfTestsMessage(runToken, suitePath, suiteName, String.valueOf(numberOfTests));
        sendMessage(message);
    }

    public void notifyStartOf(MunitTest test) {
        String message = MessageBuilder.testStartMessage(runToken, suitePath, suiteName, test.getName());
        sendMessage(message);
    }

    public void notify(TestResult testResult) {
        String message;

        if (testResult.getError() != null) {
            message = MessageBuilder.testErrorMessage(runToken, suitePath, suiteName, testResult.getTestName(), testResult.getError().getFullMessage());
        } else if (testResult.getFailure() != null) {
            message = MessageBuilder.testFailureMessage(runToken, suitePath, suiteName, testResult.getTestName(), testResult.getFailure().getFullMessage());
        } else {
            message = MessageBuilder.testFinishedMessage(runToken, suitePath, suiteName, testResult.getTestName());
        }

        sendMessage(message);
    }

    @Override
    public void notifyIgnored(TestResult testResult) {
        String message = MessageBuilder.testIgnoredMessage(runToken, suitePath, suiteName, testResult.getName());
        sendMessage(message);
    }

    @Override
    public void notifyEnd(SuiteResult result) {
        // DO NOTHING
        // TODO: FIX THIS
    }


    @Override
    public void notifySuiteFinished() {
        String message = MessageBuilder.testSuiteFinishedMessage(runToken, suitePath, suiteName);
        sendMessage(message);
    }

    @Override
    public void notifyCoverageReport(String coverageReportJson) {
        String message = MessageBuilder.notifyCoverageReportMessage(runToken, coverageReportJson);
        sendMessage(message);
    }

    @Override
    public void notifyRunFinish() {
        String message = MessageBuilder.runFinishedMessage(runToken);
        sendMessage(message);

    }


    private void sendMessage(String message) {
        try {
            out.writeObject(message);
            out.flush();
        } catch (IOException e) {
            // This can only happens if studio crashes
            e.printStackTrace();
        }
    }

}