/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.config;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunConfiguration {
    private List<String> suiteList;
    private List<String> testList;
    private List<String> notifiers;
    private String runToken;
    private boolean runCoverage;
    private int coveragePort;
    private int port;
    private String applicationPaths;
    private String projectName;
    private Set<String> ignoreFlows;

    public List<String> getSuiteList() {
        return this.suiteList;
    }

    public String getRunToken() {
        return this.runToken;
    }

    public List<String> getTestList() {
        return this.testList;
    }

    public int getCoveragePort() {
        return this.coveragePort;
    }

    public int getPort() {
        return this.port;
    }

    public String getApplicationPaths() {
        return this.applicationPaths;
    }

    public boolean isRunCoverage() {
        return this.runCoverage;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<String> getNotifiers() {
        return this.notifiers;
    }

    public Set<String> getIgnoreFlows() {
        return this.ignoreFlows;
    }

    public void setSuiteList(List<String> suiteList) {
        Validate.notEmpty(suiteList, (String)this.emptyMessage("The suite list"), (Object[])new Object[0]);
        this.suiteList = suiteList;
    }

    public void setTestList(List<String> testList) {
        this.testList = testList;
    }

    public void setRunToken(String runToken) {
        Validate.notEmpty((CharSequence)runToken, (String)this.emptyMessage("The run token"), (Object[])new Object[0]);
        this.runToken = runToken;
    }

    public void setApplicationPaths(String applicationPaths) {
        this.applicationPaths = applicationPaths;
    }

    public void setCoveragePort(Integer coveragePort) {
        Validate.notNull((Object)coveragePort, (String)this.emptyMessage("The coverage port"), (Object[])new Object[0]);
        this.coveragePort = coveragePort;
    }

    public void setRunCoverage(Boolean runCoverage) {
        this.runCoverage = runCoverage;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setNotifiers(List<String> notifiers) {
        this.notifiers = notifiers;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Suites: " + this.suiteList);
        if (!this.testList.isEmpty()) {
            sb.append("\nTest: " + this.testList);
        }
        sb.append("\nRun Token: " + this.runToken);
        sb.append("\nProject: " + this.projectName);
        sb.append("\nApp Paths: " + this.applicationPaths);
        sb.append("\nRun Coverage: " + this.runCoverage);
        return sb.toString();
    }

    private String emptyMessage(String param) {
        return String.format("%s cannot be empty", param);
    }

    public void setIgnoreFlows(Set<String> ignoreFlows) {
        this.ignoreFlows = ignoreFlows;
    }
}

