/*
* Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
* copyright law. All use of this software is subject to MuleSoft's Master Subscription
* Agreement (or other master license agreement) separately entered into in writing between
* you and MuleSoft. If such an agreement is not in place, you may not use the software.
*/

package org.mule.munit.remote.config;

/**
 * Defines the Container configuration
 * 
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class ContainerConfiguration {

  private String runtimeId;
  private String product;
  private String munitWorkingDirectoryPath;
  private String log4JConfigurationFilePath;
  private MavenConfiguration mavenConfiguration;

  protected ContainerConfiguration(String runtimeId, String product, String munitWorkingDirectoryPath,
                                   String log4JConfigurationFilePath, MavenConfiguration mavenConfiguration) {
    this.runtimeId = runtimeId;
    this.product = product;
    this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
    this.log4JConfigurationFilePath = log4JConfigurationFilePath;
    this.mavenConfiguration = mavenConfiguration;
  }

  public String getRuntimeId() {
    return runtimeId;
  }

  public String getProduct() {
    return product;
  }

  public String getMunitWorkingDirectoryPath() {
    return munitWorkingDirectoryPath;
  }

  public String getLog4JConfigurationFilePath() {
    return log4JConfigurationFilePath;
  }

  public MavenConfiguration getMavenConfiguration() {
    return mavenConfiguration;
  }

  public static class ContainerConfigurationBuilder {

    private String runtimeId;
    private String product;
    private String munitWorkingDirectoryPath;
    private String log4JConfigurationFilePath;
    private MavenConfiguration mavenConfiguration;

    public ContainerConfigurationBuilder withRuntimeId(String runtimeId) {
      this.runtimeId = runtimeId;
      return this;
    }

    public ContainerConfigurationBuilder withMunitWorkingDirectoryPath(String munitWorkingDirectoryPath) {
      this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
      return this;
    }

    public ContainerConfigurationBuilder withLog4JConfigurationFilePath(String log4JConfigurationFilePath) {
      this.log4JConfigurationFilePath = log4JConfigurationFilePath;
      return this;
    }

    public ContainerConfigurationBuilder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
      this.mavenConfiguration = mavenConfiguration;
      return this;
    }

    public ContainerConfigurationBuilder withProduct(String product) {
      this.product = product;
      return this;
    }

    public ContainerConfiguration build() {
      return new ContainerConfiguration(runtimeId, product, munitWorkingDirectoryPath, log4JConfigurationFilePath,
                                        mavenConfiguration);
    }
  }

}
