/*
* Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
* copyright law. All use of this software is subject to MuleSoft's Master Subscription
* Agreement (or other master license agreement) separately entered into in writing between
* you and MuleSoft. If such an agreement is not in place, you may not use the software.
*/

package org.mule.munit.remote.config;

import java.util.Collections;
import java.util.Set;

public class CoverageConfiguration {

  private int coveragePort;
  private boolean shouldRunCoverage;

  private String applicationPaths;
  private Set<String> ignoredFlowNames = Collections.emptySet();

  protected CoverageConfiguration(int coveragePort, Boolean shouldRunCoverage, String applicationPaths,
                                  Set<String> ignoredFlowNames) {
    this.coveragePort = coveragePort;
    this.shouldRunCoverage = shouldRunCoverage;
    this.applicationPaths = applicationPaths;
    this.ignoredFlowNames = ignoredFlowNames;
  }


  public static class CoverageConfigurationBuilder {

    private int coveragePort;
    private boolean shouldRunCoverage;

    private String applicationPaths;
    private Set<String> ignoredFlowNames;

    public CoverageConfigurationBuilder withCoveragePort(int coveragePort) {
      this.coveragePort = coveragePort;
      return this;
    }

    public CoverageConfigurationBuilder withShouldRunCoverage(Boolean shouldRunCoverage) {
      this.shouldRunCoverage = shouldRunCoverage;
      return this;
    }

    public CoverageConfigurationBuilder withApplicationPaths(String applicationPaths) {
      this.applicationPaths = applicationPaths;
      return this;
    }

    public CoverageConfigurationBuilder withIgnoredFlowNames(Set<String> ignoredFlowNames) {
      this.ignoredFlowNames = ignoredFlowNames;
      return this;
    }

    public CoverageConfiguration buid() {
      return new CoverageConfiguration(coveragePort, shouldRunCoverage, applicationPaths, ignoredFlowNames);
    }
  }


}
