/*
* Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
* copyright law. All use of this software is subject to MuleSoft's Master Subscription
* Agreement (or other master license agreement) separately entered into in writing between
* you and MuleSoft. If such an agreement is not in place, you may not use the software.
*/
package org.mule.munit.remote.config;

import java.util.List;

public class NotifierConfiguration {

  private String clazz;
  private List<NotifierParameter> parameters;

  protected NotifierConfiguration(String clazz, List<NotifierParameter> parameters) {
    this.clazz = clazz;
    this.parameters = parameters;
  }

  public String getClazz() {
    return clazz;
  }

  public List<NotifierParameter> getParameters() {
    return parameters;
  }

  public static class NotifierConfigurationBuilder {

    private String clazz;
    private List<NotifierParameter> parameters;

    public NotifierConfigurationBuilder withClazz(String clazz) {
      this.clazz = clazz;
      return this;
    }

    public NotifierConfigurationBuilder withParameters(List<NotifierParameter> parameters) {
      this.parameters = parameters;
      return this;
    }

    public NotifierConfiguration build() {
      return new NotifierConfiguration(clazz, parameters);
    }
  }
}
