package org.mule.munit.remote.config;

import java.util.List;
import java.util.Set;

/**
 * Defines the information required to run MUnit suites
 * 
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class RunConfiguration {

  private String runToken;
  private String projectName;

  private Set<String> tags;
  private Set<String> testNames;
  private Set<String> suitePaths;

  private List<NotifierConfiguration> notifierConfigurations;
  private CoverageConfiguration coverageConfiguration;
  private ContainerConfiguration containerConfiguration;

  protected RunConfiguration(String runToken, String projectName, Set<String> tags, Set<String> testNames,
                             Set<String> suitePaths, List<NotifierConfiguration> notifierConfigurations,
                             CoverageConfiguration coverageConfiguration, ContainerConfiguration containerConfiguration) {
    this.runToken = runToken;
    this.projectName = projectName;
    this.tags = tags;
    this.testNames = testNames;
    this.suitePaths = suitePaths;
    this.notifierConfigurations = notifierConfigurations;
    this.coverageConfiguration = coverageConfiguration;
    this.containerConfiguration = containerConfiguration;
  }

  public String getRunToken() {
    return runToken;
  }

  public String getProjectName() {
    return projectName;
  }

  public Set<String> getTags() {
    return tags;
  }

  public Set<String> getTestNames() {
    return testNames;
  }

  public Set<String> getSuitePaths() {
    return suitePaths;
  }


  public List<NotifierConfiguration> getNotifierConfigurations() {
    return notifierConfigurations;
  }

  public CoverageConfiguration getCoverageConfiguration() {
    return coverageConfiguration;
  }

  public ContainerConfiguration getContainerConfiguration() {
    return containerConfiguration;
  }

  public static class RunConfigurationBuilder {

    private String runToken;
    private String projectName;

    private Set<String> tags;
    private Set<String> testNames;
    private Set<String> suitePaths;


    private List<NotifierConfiguration> notifierConfigurations;
    private CoverageConfiguration coverageConfiguration;
    private ContainerConfiguration containerConfiguration;

    public RunConfigurationBuilder withRunToken(String runToken) {
      this.runToken = runToken;
      return this;
    }

    public RunConfigurationBuilder withProjectName(String projectName) {
      this.projectName = projectName;
      return this;
    }

    public RunConfigurationBuilder withTags(Set<String> tags) {
      this.tags = tags;
      return this;
    }

    public RunConfigurationBuilder withTestNames(Set<String> testNames) {
      this.testNames = testNames;
      return this;
    }

    public RunConfigurationBuilder withSuitePaths(Set<String> suitePaths) {
      this.suitePaths = suitePaths;
      return this;
    }

    public RunConfigurationBuilder withNotifierConfigurations(List<NotifierConfiguration> notifierConfigurations) {
      this.notifierConfigurations = notifierConfigurations;
      return this;
    }

    public RunConfigurationBuilder withCoverageConfiguration(CoverageConfiguration coverageConfiguration) {
      this.coverageConfiguration = coverageConfiguration;
      return this;
    }

    public RunConfigurationBuilder withContainerConfiguration(ContainerConfiguration containerConfiguration) {
      this.containerConfiguration = containerConfiguration;
      return this;
    }

    public RunConfiguration build() {
      return new RunConfiguration(runToken, projectName, tags, testNames, suitePaths, notifierConfigurations,
                                  coverageConfiguration,
                                  containerConfiguration);
    }
  }
}
