package org.mule.munit.remote.config;

import com.google.gson.Gson;
import org.apache.commons.cli.*;
import org.apache.commons.lang3.StringUtils;

import java.io.FileReader;
import java.io.IOException;

/**
 * Takes a Command Line Arguments and generates a runConfiguration
 */
public class RunConfigurationParser {

  public static final String RUN_CONFIGURATION_PARAMETER = "run_configuration";

  private static final int MIN_PORT_NUMBER = 50000;
  private static final int MAX_PORT_NUMBER = 55000;

  private Options options = new Options();
  private CommandLineParser parser = new BasicParser();

  public RunConfigurationParser() {
    options.addOption(createOption(RUN_CONFIGURATION_PARAMETER, true, "MUnit run configuration", true));
  }

  public RunConfiguration parse(String[] args) throws ParseException, IOException {
    CommandLine cmdLine = parser.parse(options, args);
    return buildRunConfiguration(cmdLine);
  }

  private RunConfiguration buildRunConfiguration(CommandLine cmd) throws IOException {
    String param = cmd.getOptionValue(RUN_CONFIGURATION_PARAMETER, StringUtils.EMPTY);
    return new Gson().fromJson(new FileReader(param), RunConfiguration.class);
  }

  private Option createOption(String name, String description) {
    return createOption(name, true, description, false);
  }

  private Option createOption(String name, boolean hasArg, String description, boolean required) {
    OptionBuilder.withDescription(description);
    OptionBuilder.hasArg(hasArg);
    OptionBuilder.isRequired(required);
    return OptionBuilder.create(name);
  }

  // private void buildCoverageConfiguration(CommandLine cmdLine, RunConfiguration runConfig) {
  // runConfig.setApplicationPaths(cmdLine.getOptionValue(APPLICATION_PATHS_PARAMETER));
  // Integer coveragePort;
  // if (cmdLine.hasOption(COVERAGE_PORT_PARAMETER)) {
  // coveragePort = Integer.parseInt(cmdLine.getOptionValue(COVERAGE_PORT_PARAMETER));
  // } else {
  // // TODO omg fix this
  // // FreePortFinder portFinder = new FreePortFinder(MIN_PORT_NUMBER, MAX_PORT_NUMBER);
  // // coveragePort = portFinder.find();
  // coveragePort = Integer.parseInt("6669");
  // }
  // runConfig.setCoveragePort(coveragePort);
  // runConfig.setIgnoreFlows(buildIgnoreFlowsList(cmdLine));
  // }

}
