package org.mule.munit.remote.notifiers;

import org.mule.munit.common.protocol.notifiers.RunMessageNotifier;

import static org.mule.munit.common.protocol.message.MessageField.FIELD_TOKEN;
import static org.mule.munit.common.protocol.message.MessageField.NEW_LINE_ESCAPE_TOKEN;

/**
 * The goal of this class is to notify through standard output all events received though the interface {@link RunMessageNotifier}
 */
public class ConsoleNotifier extends RunMessageNotifier {

  public void init() throws Exception {

  }

  @Override
  public void sendMessage(String message) {
    String singleLineMessage = message.replaceAll("[\r\n]+", NEW_LINE_ESCAPE_TOKEN);
    System.out.println(FIELD_TOKEN + singleLineMessage);
  }
}
