package org.mule.munit.remote.notifiers;

import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.notifiers.RunMessageNotifier;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;

/**
 * The goal of this class is to notify through a socket all events received though the interface {@link RunMessageNotifier}
 */
public class SocketNotifier extends RunMessageNotifier {

  private String host;
  private Integer port;
  private ObjectOutputStream out;

  public void init() throws Exception {
    String socketHost = StringUtils.isEmpty(host) ? "localhost" : host;
    Socket requestSocket = new Socket(socketHost, port);
    out = new ObjectOutputStream(requestSocket.getOutputStream());
    System.out.println("[" + this.getClass().getName() + "]" + "Connected to localhost in port " + port);
  }

  public void setHost(String host) {
    this.host = host;
  }

  public void setPort(String port) {
    this.port = Integer.valueOf(port);
  }

  @Override
  public void sendMessage(String message) {
    try {
      out.writeObject(message);
      out.flush();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

}
