/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.path;

import java.io.File;
import java.util.Set;

/**
 * The goal of this class is to build the paths of a Mule application.
 * It require the list of Mule configuration resources to do so.
 */
public class ApplicationPathBuilder {

  public static final String COBERTURA_PORT_PROPERTY = "cobertura.port";
  private static final String MULE_DEBUG_ENABLE_PROPERTY = "mule.debug.enable";
  private static final String MULE_DEBUG_SUSPEND_PROPERTY = "mule.debug.suspend";
  private static final String MULE_DEBUG_PORT_PROPERTY = "mule.debug.port";

  private String resources;
  private Boolean executed = false;
  private ApplicationPathCounter pathCounter;
  private File appDir;

  public ApplicationPathBuilder(String resources, File appDir) {
    this.resources = resources;
    this.appDir = appDir;
  }

  public String getResources() {
    return resources;
  }

  public Set<String> getFlowPaths() {
    if (false == executed) {
      buildApplicationPaths();
    }

    return pathCounter.getFlowPaths();
  }

  public Set<String> getSubFlowPaths() {
    if (false == executed) {
      buildApplicationPaths();
    }
    return pathCounter.getSubFlowPaths();
  }

  public Set<String> getBatchPaths() {
    if (false == executed) {
      buildApplicationPaths();
    }
    return pathCounter.getBatchPaths();
  }

  /**
   * The method starts a Mule context ( by MUnit) and ones Mule has started it build the paths of all the flows
   * and sub-flows present in the application.
   */
  private void buildApplicationPaths() {
    executed = true;
    String originalCoveragePort = System.clearProperty(COBERTURA_PORT_PROPERTY);
    String originalDebugEnable = System.clearProperty(MULE_DEBUG_ENABLE_PROPERTY);
    String originalDebugSuspend = System.clearProperty(MULE_DEBUG_SUSPEND_PROPERTY);
    String originalDebugPort = System.clearProperty(MULE_DEBUG_PORT_PROPERTY);

    //        List<MunitSimpleRunnerAction> actions = new ArrayList<MunitSimpleRunnerAction>();
    //        pathCounter = new ApplicationPathCounter();
    //        actions.add(pathCounter);

    //        MunitSimpleRunner munitSimpleRunner = new MunitSimpleRunner(resources, actions, appDir, classLoaderHolder);
    //        munitSimpleRunner.run();

    if (null != originalCoveragePort) {
      System.setProperty(COBERTURA_PORT_PROPERTY, originalCoveragePort);
    }

    if (null != originalDebugEnable) {
      System.setProperty(MULE_DEBUG_ENABLE_PROPERTY, originalDebugEnable);
    }

    if (null != originalDebugSuspend) {
      System.setProperty(MULE_DEBUG_SUSPEND_PROPERTY, originalDebugSuspend);
    }

    if (null != originalDebugPort) {
      System.setProperty(MULE_DEBUG_PORT_PROPERTY, originalDebugPort);
    }



  }
}
