/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.munit.remote.FolderNames;

public class ApplicationStructureGenerator {
    private File sourceFolder;
    private File destinationFolder;

    public ApplicationStructureGenerator(File sourceFolder, File destinationFolder) {
        Preconditions.checkArgument((boolean)sourceFolder.exists(), (Object)("The source folder " + sourceFolder.getAbsolutePath() + " should exists"));
        Preconditions.checkArgument((boolean)destinationFolder.exists(), (Object)("The destination folder " + destinationFolder.getAbsolutePath() + " should exists"));
        this.sourceFolder = sourceFolder;
        this.destinationFolder = destinationFolder;
    }

    public void generate() throws Exception {
        Paths.get(this.destinationFolder.getAbsolutePath(), FolderNames.APPLICATION.value()).toFile().mkdir();
        this.copyDirectory(FolderNames.CLASSES.value(), FolderNames.CLASSES.value(), true, false);
        this.copyDirectory(FolderNames.TEST_CLASSES.value(), FolderNames.CLASSES.value(), false, false);
        this.copyDirectory(FolderNames.MULE.value(), FolderNames.CLASSES.value(), true, false);
        this.copyDirectory(FolderNames.TEST_MULE.value(), FolderNames.MULE.value(), true, false);
        this.copyDirectory(FolderNames.META_INF.value(), FolderNames.META_INF.value(), true, false);
        this.copyDirectory(FolderNames.REPOSITORY.value(), FolderNames.REPOSITORY.value(), false, true);
    }

    private void copyDirectory(String src, String dst, Boolean checkSrc, Boolean doNotCopyIfEmpty) throws Exception {
        Path sourcePath = Paths.get(this.sourceFolder.getAbsolutePath(), src);
        Path destinationPath = Paths.get(this.destinationFolder.getAbsolutePath(), FolderNames.APPLICATION.value(), dst);
        String srcAbsolutePath = sourcePath.toAbsolutePath().toString();
        String dstAbsolutePath = destinationPath.toAbsolutePath().toString();
        if (checkSrc.booleanValue() && !sourcePath.toFile().exists()) {
            throw new IllegalArgumentException("The source folder " + srcAbsolutePath + " should exists");
        }
        if (!checkSrc.booleanValue() && !sourcePath.toFile().exists()) {
            return;
        }
        try {
            if (doNotCopyIfEmpty.booleanValue() && FileUtils.listFiles((File)sourcePath.toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).isEmpty()) {
                return;
            }
            FileUtils.copyDirectory((File)sourcePath.toFile(), (File)destinationPath.toFile());
        }
        catch (IOException e) {
            throw new Exception("Fail to copy content from " + srcAbsolutePath + " to " + dstAbsolutePath, e);
        }
    }
}

