/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListenerContainer;
import org.mule.munit.common.util.FileUtils;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.client.RunnerClient;
import org.mule.munit.remote.classloading.ClassLoaderUtils;
import org.mule.munit.remote.config.NotifierConfiguration;
import org.mule.munit.remote.config.RunConfiguration;
import org.mule.munit.remote.config.RunConfigurationParser;
import org.mule.munit.remote.container.ContainerFactory;
import org.mule.munit.remote.notifier.NotifierReflectionFactory;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;

public class RemoteRunner {
    public static final String MUNIT_SERVER_PORT = "munit.server.port";
    public static final String SYSTEM_PROPERTIES_FILE = "munit.system.properties.file";
    public static final String MUNIT_DEBUG_LOG_CLASSPATH = "munit.debug.log.classpath";
    private static final String CONTAINER_START_FAILURE = "org.mule.runtime.deployment.model.api.DeploymentInitException";
    public static final String MULE_APPLICATION_JSON = "mule-application.json";
    private ContainerFactory containerFactory;
    private MuleApplicationModel.MuleApplicationModelBuilder muleApplicationModelBuilder = null;

    public static void main(String[] args) throws ParseException, IOException, URISyntaxException {
        RemoteRunner.loadSystemPropertiesFileIfPresent();
        RunConfiguration runConfig = new RunConfigurationParser().parse(args);
        RemoteRunner runner = new RemoteRunner();
        runner.setContainerFactory(new ContainerFactory());
        runner.run(runConfig);
        RemoteRunner.shutDown();
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
    }

    public void run(RunConfiguration runConfig) throws IOException, URISyntaxException {
        System.out.println("[" + this.getClass().getName() + "]Run Started");
        this.logClassPathIfNecessary();
        RemoteRunEventListener listener = this.buildRunnerListener(runConfig.getNotifierConfigurations());
        int munitRunnerPort = Integer.parseInt(System.getProperty(MUNIT_SERVER_PORT));
        listener.notifyRunStart();
        try {
            for (String munitSuite : runConfig.getSuitePaths()) {
                this.runSuite(runConfig, listener, munitSuite, munitRunnerPort);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            listener.notifyUnexpectedError(ExceptionUtils.getStackTrace((Throwable)e));
        }
        listener.notifyRunFinish();
        System.out.println("[" + this.getClass().getName() + "]Done");
    }

    protected void runSuite(RunConfiguration runConfig, RemoteRunEventListener listener, String suite, int port) throws Exception {
        this.updateMuleApplicationJson(suite, runConfig.getContainerConfiguration().getMunitWorkingDirectoryPath());
        EmbeddedContainer container = this.containerFactory.createContainer(runConfig.getContainerConfiguration());
        try {
            container.start();
            RunnerClient runnerClient = this.buildRunnerClient(listener, port);
            runnerClient.sendSuiteRunInfo(runConfig.getRunToken(), suite, runConfig.getTestNames(), runConfig.getTags());
            runnerClient.receiveAndNotify();
            container.stop();
        }
        catch (RuntimeException e) {
            if (this.isContainerFailure(e)) {
                listener.notifyContainerFailure(suite, ExceptionUtils.getStackTrace((Throwable)e));
                e.printStackTrace();
            }
            throw e;
        }
    }

    private void updateMuleApplicationJson(String suitePath, String munitWorkingDirectoryPath) throws IOException {
        Path relativeSuitePath = Paths.get(FolderNames.MUNIT.value(), suitePath);
        Path applicationJsonPath = Paths.get(munitWorkingDirectoryPath, FolderNames.APPLICATION.value(), FolderNames.META_INF.value(), FolderNames.MULE_ARTIFACT.value(), MULE_APPLICATION_JSON);
        MuleApplicationModel.MuleApplicationModelBuilder builder = this.getApplicationModelBuilder(applicationJsonPath.toFile());
        builder.setConfigs(Collections.singletonList(relativeSuitePath.toString()));
        String applicationDescriptorContent = new MuleApplicationModelJsonSerializer().serialize((AbstractMuleArtifactModel)builder.build());
        try (FileWriter fileWriter = new FileWriter(applicationJsonPath.toAbsolutePath().toString());){
            fileWriter.write(applicationDescriptorContent);
        }
        catch (IOException e) {
            throw new MunitError("Fail to update: " + applicationJsonPath.toAbsolutePath().toString(), (Throwable)e);
        }
    }

    private MuleApplicationModel.MuleApplicationModelBuilder getApplicationModelBuilder(File applicationJsonFile) throws IOException {
        if (this.muleApplicationModelBuilder == null) {
            MuleApplicationModel muleApplicationModel = this.getMuleApplicationModel(applicationJsonFile);
            MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
            builder.setMinMuleVersion(muleApplicationModel.getMinMuleVersion());
            muleApplicationModel.getDomain().ifPresent(arg_0 -> ((MuleApplicationModel.MuleApplicationModelBuilder)builder).setDomain(arg_0));
            builder.setRedeploymentEnabled(muleApplicationModel.isRedeploymentEnabled());
            builder.setName(muleApplicationModel.getName());
            MuleArtifactLoaderDescriptorBuilder muleArtifactLoaderDescriptorBuilder = builder.withClassLoaderModelDescriber();
            if (!muleApplicationModel.getClassLoaderModelLoaderDescriptor().isPresent()) {
                throw new MunitError("Fail to read " + applicationJsonFile.getAbsolutePath() + ". Classloader model descriptor is missing.");
            }
            muleArtifactLoaderDescriptorBuilder.setId(((MuleArtifactLoaderDescriptor)muleApplicationModel.getClassLoaderModelLoaderDescriptor().get()).getId());
            builder.withBundleDescriptorLoader(muleApplicationModel.getBundleDescriptorLoader());
            builder.withBundleDescriptorLoader(muleArtifactLoaderDescriptorBuilder.build());
            this.muleApplicationModelBuilder = builder;
        }
        return this.muleApplicationModelBuilder;
    }

    private MuleApplicationModel getMuleApplicationModel(File applicationJsonFile) throws IOException {
        return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)applicationJsonFile, (Charset)Charset.defaultCharset()));
    }

    protected RunnerClient buildRunnerClient(RemoteRunEventListener listener, int port) throws IOException {
        return new RunnerClient(port, listener);
    }

    protected boolean isContainerFailure(RuntimeException e) {
        return e.getCause() != null && CONTAINER_START_FAILURE.equals(e.getCause().getClass().getCanonicalName());
    }

    protected RemoteRunEventListener buildRunnerListener(List<NotifierConfiguration> configurations) throws IOException {
        List<RunEventListener> listeners = new NotifierReflectionFactory().createNotifiers(configurations);
        RunEventListenerContainer container = new RunEventListenerContainer();
        listeners.forEach(arg_0 -> ((RunEventListenerContainer)container).addNotificationListener(arg_0));
        return container;
    }

    private void logClassPathIfNecessary() {
        if (Boolean.valueOf(System.getProperty(MUNIT_DEBUG_LOG_CLASSPATH, "false")).booleanValue()) {
            System.out.println("[" + this.getClass().getName() + "]logging classpath ...");
            new ClassLoaderUtils().getClassPath().forEach(System.out::println);
            System.out.println("[" + this.getClass().getName() + "]logging classpath DONE");
        }
    }

    private static void loadSystemPropertiesFileIfPresent() {
        String filePath = System.getProperty(SYSTEM_PROPERTIES_FILE);
        try {
            if (filePath != null) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(new File(filePath)));
                MUnitUserPropertiesManager.loadPropertiesToSystem((Properties)properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void shutDown() {
        System.exit(0);
    }
}

