/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.client;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListenerContainer;
import org.mule.munit.common.protocol.message.RunMessage;
import org.mule.munit.common.protocol.message.RunMessageParser;

public class RunnerClient {
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private boolean suiteRunning = true;
    private RunMessageParser parser;

    public RunnerClient(int port, RemoteRunEventListener runnerEventListener) throws IOException {
        Socket requestSocket = new Socket("localhost", port);
        this.in = new ObjectInputStream(requestSocket.getInputStream());
        this.out = new ObjectOutputStream(requestSocket.getOutputStream());
        this.parser = this.buildParser(runnerEventListener);
    }

    public void sendSuiteRunInfo(String runToken, String suite, Set<String> testNames, Set<String> tags) throws IOException {
        this.send(new Gson().toJson((Object)new RunMessage(Integer.valueOf(0), (Map)ImmutableMap.of((Object)"runToken", (Object)runToken, (Object)"munitSuite", (Object)suite, (Object)"testNames", (Object)this.collectionToString(testNames), (Object)"tags", (Object)this.collectionToString(tags)))));
    }

    public void receiveAndNotify() throws IOException, ClassNotFoundException {
        do {
            String message = (String)this.in.readObject();
            this.parser.parseAndNotify(message);
        } while (this.suiteRunning);
    }

    private void finish() {
        this.suiteRunning = false;
    }

    private void send(String message) throws IOException {
        this.out.writeObject(message);
        this.out.flush();
    }

    private String collectionToString(Collection<String> collection) {
        return collection == null ? "" : collection.stream().collect(Collectors.joining(","));
    }

    private RunMessageParser buildParser(RemoteRunEventListener runnerEventListener) {
        RunEventListenerContainer runnerEventListenerContainer = new RunEventListenerContainer();
        runnerEventListenerContainer.addNotificationListener((RunEventListener)runnerEventListener);
        runnerEventListenerContainer.addNotificationListener((RunEventListener)new SuiteFinishedListener());
        return new RunMessageParser((RunEventListener)runnerEventListenerContainer);
    }

    private class SuiteFinishedListener
    implements RunEventListener {
        private SuiteFinishedListener() {
        }

        public void notifySuiteUnexpectedError(String stackTrace) {
            this.notifyUnexpectedError(stackTrace);
        }

        public void notifySuiteEnd(String suite, long elapsedTime) {
            RunnerClient.this.finish();
        }

        public void notifyUnexpectedError(String stackTrace) {
            RunnerClient.this.finish();
        }
    }
}

