/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.config;

public class MavenConfiguration {
    private String settingsXmlFilePath;
    private String globalSettingsXmlFilePath;
    private String mavenRepositoryDirectoryPath;
    private Boolean forcePolicyUpdate = Boolean.FALSE;

    protected MavenConfiguration(String settingsXmlFilePath, String globalSettingsXmlFilePath, String mavenRepositoryDirectoryPath, Boolean forcePolicyUpdate) {
        this.settingsXmlFilePath = settingsXmlFilePath;
        this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
        this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
        this.forcePolicyUpdate = forcePolicyUpdate;
    }

    public String getSettingsXmlFilePath() {
        return this.settingsXmlFilePath;
    }

    public String getGlobalSettingsXmlFilePath() {
        return this.globalSettingsXmlFilePath;
    }

    public String getMavenRepositoryDirectoryPath() {
        return this.mavenRepositoryDirectoryPath;
    }

    public Boolean getForcePolicyUpdate() {
        return this.forcePolicyUpdate;
    }

    public static class MavenConfigurationBuilder {
        private String settingsXmlFilePath;
        private String globalSettingsXmlFilePath;
        private String mavenRepositoryDirectoryPath;
        private Boolean forcePolicyUpdate;

        public MavenConfigurationBuilder withSettingsXmlFilePath(String settingsXmlFilePath) {
            this.settingsXmlFilePath = settingsXmlFilePath;
            return this;
        }

        public MavenConfigurationBuilder withGlobalSettingsXmlFilePath(String globalSettingsXmlFilePath) {
            this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
            return this;
        }

        public MavenConfigurationBuilder withMavenRepositoryDirectoryPath(String mavenRepositoryDirectoryPath) {
            this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
            return this;
        }

        public MavenConfigurationBuilder withForcePolicyUpdate(Boolean forcePolicyUpdate) {
            this.forcePolicyUpdate = forcePolicyUpdate;
            return this;
        }

        public MavenConfiguration build() {
            return new MavenConfiguration(this.settingsXmlFilePath, this.globalSettingsXmlFilePath, this.mavenRepositoryDirectoryPath, this.forcePolicyUpdate);
        }
    }
}

