/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.config;

import java.util.List;
import java.util.Set;
import org.mule.munit.remote.config.ContainerConfiguration;
import org.mule.munit.remote.config.CoverageConfiguration;
import org.mule.munit.remote.config.NotifierConfiguration;

public class RunConfiguration {
    private String runToken;
    private String projectName;
    private Set<String> tags;
    private Set<String> testNames;
    private Set<String> suitePaths;
    private List<NotifierConfiguration> notifierConfigurations;
    private CoverageConfiguration coverageConfiguration;
    private ContainerConfiguration containerConfiguration;

    protected RunConfiguration(String runToken, String projectName, Set<String> tags, Set<String> testNames, Set<String> suitePaths, List<NotifierConfiguration> notifierConfigurations, CoverageConfiguration coverageConfiguration, ContainerConfiguration containerConfiguration) {
        this.runToken = runToken;
        this.projectName = projectName;
        this.tags = tags;
        this.testNames = testNames;
        this.suitePaths = suitePaths;
        this.notifierConfigurations = notifierConfigurations;
        this.coverageConfiguration = coverageConfiguration;
        this.containerConfiguration = containerConfiguration;
    }

    public String getRunToken() {
        return this.runToken;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getTestNames() {
        return this.testNames;
    }

    public Set<String> getSuitePaths() {
        return this.suitePaths;
    }

    public List<NotifierConfiguration> getNotifierConfigurations() {
        return this.notifierConfigurations;
    }

    public CoverageConfiguration getCoverageConfiguration() {
        return this.coverageConfiguration;
    }

    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public static class RunConfigurationBuilder {
        private String runToken;
        private String projectName;
        private Set<String> tags;
        private Set<String> testNames;
        private Set<String> suitePaths;
        private List<NotifierConfiguration> notifierConfigurations;
        private CoverageConfiguration coverageConfiguration;
        private ContainerConfiguration containerConfiguration;

        public RunConfigurationBuilder withRunToken(String runToken) {
            this.runToken = runToken;
            return this;
        }

        public RunConfigurationBuilder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public RunConfigurationBuilder withTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public RunConfigurationBuilder withTestNames(Set<String> testNames) {
            this.testNames = testNames;
            return this;
        }

        public RunConfigurationBuilder withSuitePaths(Set<String> suitePaths) {
            this.suitePaths = suitePaths;
            return this;
        }

        public RunConfigurationBuilder withNotifierConfigurations(List<NotifierConfiguration> notifierConfigurations) {
            this.notifierConfigurations = notifierConfigurations;
            return this;
        }

        public RunConfigurationBuilder withCoverageConfiguration(CoverageConfiguration coverageConfiguration) {
            this.coverageConfiguration = coverageConfiguration;
            return this;
        }

        public RunConfigurationBuilder withContainerConfiguration(ContainerConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
            return this;
        }

        public RunConfiguration build() {
            return new RunConfiguration(this.runToken, this.projectName, this.tags, this.testNames, this.suitePaths, this.notifierConfigurations, this.coverageConfiguration, this.containerConfiguration);
        }
    }
}

