/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.config.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.ApplicationConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;

public class ContainerFactory {
    protected static final String MAVEN_CENTRAL_ID = "maven-central";
    protected static final String MULESOFT_PUBLIC_ID = "mulesoft-public";
    protected static final String MAVEN_CENTRAL_URL = "https://repo.maven.apache.org/maven2/";
    protected static final String MULESOFT_PUBLIC_URL = "https://repository.mulesoft.org/nexus/content/repositories/public";

    public EmbeddedContainer createContainer(ContainerConfiguration configuration) throws IOException {
        URL containerBaseFolder = Paths.get(configuration.getMunitWorkingDirectoryPath(), FolderNames.CONTAINER.value()).toFile().toURI().toURL();
        String runtimeVersion = configuration.getRuntimeId();
        String product = configuration.getProduct();
        File log4JConfigurationFile = this.getLog4JConfigurationFile(configuration);
        DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.builder().withTestDependenciesEnabled(true).build();
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.builder().withApplicationLocation(Paths.get(configuration.getMunitWorkingDirectoryPath(), FolderNames.APPLICATION.value()).toFile()).withDeploymentConfiguration(deploymentConfiguration).build();
        return EmbeddedContainer.builder().withMuleVersion(runtimeVersion).withProduct(Product.valueOf((String)product)).withLog4jConfigurationFile(log4JConfigurationFile.toURI()).withContainerBaseFolder(containerBaseFolder).withApplicationConfiguration(applicationConfiguration).withMavenConfiguration(this.getMavenConfiguration(configuration.getMavenConfiguration())).build();
    }

    protected File getLog4JConfigurationFile(ContainerConfiguration runConfig) {
        File log4JConfigurationFile;
        String log4JConfigurationFilePath = runConfig.getLog4JConfigurationFilePath();
        if (StringUtils.isNotBlank((CharSequence)log4JConfigurationFilePath) && (log4JConfigurationFile = Paths.get(log4JConfigurationFilePath, new String[0]).toFile()) != null && log4JConfigurationFile.exists()) {
            return log4JConfigurationFile;
        }
        return null;
    }

    protected MavenConfiguration getMavenConfiguration(org.mule.munit.remote.config.MavenConfiguration configuration) throws MalformedURLException {
        File globalSettingsXml;
        File settingsXml;
        File mavenRepository;
        MavenConfiguration.MavenConfigurationBuilder builder = MavenConfiguration.newMavenConfigurationBuilder();
        if (configuration.getMavenRepositoryDirectoryPath() != null && (mavenRepository = Paths.get(configuration.getMavenRepositoryDirectoryPath(), new String[0]).toFile()).exists()) {
            builder.withLocalMavenRepositoryLocation(mavenRepository);
        }
        if (configuration.getSettingsXmlFilePath() != null && (settingsXml = Paths.get(configuration.getSettingsXmlFilePath(), new String[0]).toFile()).exists()) {
            builder.withUserSettingsLocation(settingsXml);
        }
        if (configuration.getGlobalSettingsXmlFilePath() != null && (globalSettingsXml = Paths.get(configuration.getGlobalSettingsXmlFilePath(), new String[0]).toFile()).exists()) {
            builder.withGlobalSettingsLocation(globalSettingsXml);
        }
        if (configuration.getForcePolicyUpdate().booleanValue()) {
            builder.withForcePolicyUpdateNever(false);
        } else {
            builder.withForcePolicyUpdateNever(true);
        }
        this.addDefaultRepositories(builder);
        return builder.build();
    }

    protected void addDefaultRepositories(MavenConfiguration.MavenConfigurationBuilder builder) throws MalformedURLException {
        builder.withRemoteRepository(RemoteRepository.newRemoteRepositoryBuilder().withId(MAVEN_CENTRAL_ID).withUrl(new URL(MAVEN_CENTRAL_URL)).build());
        builder.withRemoteRepository(RemoteRepository.newRemoteRepositoryBuilder().withId(MULESOFT_PUBLIC_ID).withUrl(new URL(MULESOFT_PUBLIC_URL)).build());
    }
}

