/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.notifier;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.notifiers.RunMessageNotifier;
import org.mule.munit.remote.config.NotifierConfiguration;
import org.mule.munit.remote.config.NotifierParameter;

public class NotifierReflectionFactory {
    public static final String SET_PREFIX = "set";

    public List<RunEventListener> createNotifiers(List<NotifierConfiguration> notifierConfigurations) {
        Preconditions.checkNotNull(notifierConfigurations, (Object)"The configurations can not be null");
        Preconditions.checkArgument((notifierConfigurations.size() >= 1 ? 1 : 0) != 0, (Object)"There must be at least one notifier configuration");
        return notifierConfigurations.stream().map(this::createNotifierInstance).collect(Collectors.toList());
    }

    private RunEventListener createNotifierInstance(NotifierConfiguration nc) {
        try {
            RunEventListener listener = (RunEventListener)Class.forName(nc.getClazz()).newInstance();
            this.configureNotifier(nc.getParameters(), listener);
            this.initNotifier(listener);
            return listener;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Fail to create instance for notifier: " + nc.getClazz(), e);
        }
    }

    private void configureNotifier(List<NotifierParameter> parameters, RunEventListener listener) {
        for (NotifierParameter parameter : parameters) {
            Method method = this.getMethod(listener, parameter);
            method.setAccessible(true);
            try {
                method.invoke((Object)listener, parameter.getValue());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Fail to configure instance of notifier: " + listener.getClass().getCanonicalName(), e);
            }
        }
    }

    private Method getMethod(RunEventListener listener, NotifierParameter parameter) {
        String setMethod = SET_PREFIX + StringUtils.capitalize((String)parameter.getName());
        try {
            return listener.getClass().getMethod(setMethod, Class.forName(parameter.getType()));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Fail to get setter method: " + setMethod + " in class " + listener.getClass().getCanonicalName(), e);
        }
    }

    private void initNotifier(RunEventListener listener) {
        try {
            ((RunMessageNotifier)listener).init();
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to init instance of notifier: " + listener.getClass().getCanonicalName(), e);
        }
    }
}

